/*
 * Decompiled with CFR 0.152.
 */
package beyond_earth_giselle_addon.common.block.entity;

import beyond_earth_giselle_addon.common.config.AddonConfigs;
import beyond_earth_giselle_addon.common.content.gravity.GravityNormalizeUtils;
import beyond_earth_giselle_addon.common.inventory.GravityNormalizerContainerMenu;
import beyond_earth_giselle_addon.common.registries.AddonBlockEntityTypes;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.energy.IEnergyStorage;
import net.mrscauthd.beyond_earth.machines.tile.AbstractMachineBlockEntity;
import net.mrscauthd.beyond_earth.machines.tile.NamedComponentRegistry;
import net.mrscauthd.beyond_earth.machines.tile.PowerSystem;
import net.mrscauthd.beyond_earth.machines.tile.PowerSystemEnergyCommon;
import net.mrscauthd.beyond_earth.machines.tile.PowerSystemRegistry;

public class GravityNormalizerBlockEntity
extends AbstractMachineBlockEntity {
    public static final String DATA_RANGE_KEY = "range";
    public static final String DATA_WORKINGAREA_VISIBLE_KEY = "workingAreaVisible";
    private PowerSystem energyPowerSystem;

    public GravityNormalizerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)AddonBlockEntityTypes.GRAVITY_NORMALIZER.get(), pos, state);
        this.setWorkingAreaVisible(false);
    }

    public AABB getRenderBoundingBox() {
        return this.getWorkingArea();
    }

    protected void createEnergyStorages(NamedComponentRegistry<IEnergyStorage> registry) {
        super.createEnergyStorages(registry);
        registry.put((Object)this.createEnergyStorageCommon());
    }

    protected void createPowerSystems(PowerSystemRegistry map) {
        this.energyPowerSystem = new PowerSystemEnergyCommon(this){

            public int getBasePowerForOperation() {
                return GravityNormalizerBlockEntity.this.getBasePowerForOperation();
            }
        };
        map.put(this.energyPowerSystem);
    }

    public int getBasePowerForOperation() {
        return this.getBasePowerForOperation(this.getRange());
    }

    public int getBasePowerForOperation(int range) {
        int base = (Integer)AddonConfigs.Common.machines.gravityNormalizer_energyUsingBase.get();
        int perRange = (Integer)AddonConfigs.Common.machines.gravityNormalizer_energyUsingPerRange.get();
        return base + range * perRange;
    }

    public boolean hasSpaceInOutput() {
        return true;
    }

    @Nullable
    public AbstractContainerMenu m_6555_(int windowId, Inventory inv) {
        return new GravityNormalizerContainerMenu(windowId, inv, this);
    }

    public void tick() {
        this.doNormalize();
        super.tick();
    }

    protected void tickProcessing() {
    }

    protected void doNormalize() {
        if (this.consumePowerForOperation() != null) {
            this.doNormalize(this.getWorkingArea());
        }
    }

    protected void doNormalize(AABB workingArea) {
        Level level = this.m_58904_();
        List livings = level.m_45976_(LivingEntity.class, workingArea);
        for (LivingEntity entity : livings) {
            GravityNormalizeUtils.setNormalizing((Entity)entity, true);
        }
        List items = level.m_45976_(ItemEntity.class, workingArea);
        for (ItemEntity entity : items) {
            GravityNormalizeUtils.setNormalizing((Entity)entity, true);
        }
        this.setProcessedInThisTick();
    }

    public int getRange() {
        return Math.max(this.getTileData().m_128451_(DATA_RANGE_KEY), 1);
    }

    public void setRange(int range) {
        range = Math.min(Math.max(range, 1), 15);
        if (this.getRange() != range) {
            this.getTileData().m_128405_(DATA_RANGE_KEY, range);
            this.m_6596_();
        }
    }

    public boolean isWorkingAreaVisible() {
        return this.getTileData().m_128471_(DATA_WORKINGAREA_VISIBLE_KEY);
    }

    public void setWorkingAreaVisible(boolean visible) {
        if (this.isWorkingAreaVisible() != visible) {
            this.getTileData().m_128379_(DATA_WORKINGAREA_VISIBLE_KEY, visible);
            this.m_6596_();
        }
    }

    public AABB getWorkingArea() {
        return this.getWorkingArea(this.getRange());
    }

    public AABB getWorkingArea(double range) {
        return this.getWorkingArea(this.m_58899_(), range);
    }

    public AABB getWorkingArea(BlockPos pos, double range) {
        return new AABB(pos).m_82400_(range).m_82386_(0.0, range, 0.0);
    }

    public PowerSystem getEnergyPowerSystem() {
        return this.energyPowerSystem;
    }
}

