/*
 * Decompiled with CFR 0.152.
 */
package beyond_earth_giselle_addon.common.capability;

import beyond_earth_giselle_addon.common.capability.CapabilityOxygenCharger;
import beyond_earth_giselle_addon.common.capability.ChargeMode;
import beyond_earth_giselle_addon.common.capability.IOxygenCharger;
import beyond_earth_giselle_addon.common.item.OxygenCanItem;
import beyond_earth_giselle_addon.common.registries.AddonItems;
import beyond_earth_giselle_addon.common.util.LivingEntityHelper;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.mrscauthd.beyond_earth.capability.oxygen.IOxygenStorage;
import net.mrscauthd.beyond_earth.gauge.GaugeValueSimple;
import net.mrscauthd.beyond_earth.gauge.IGaugeValue;

public class OxygenChargerUtils {
    public static IGaugeValue getInventoryOxygenChargerStorage(LivingEntity entity) {
        List<ItemStack> itemStacks = LivingEntityHelper.getInventoryStacks(entity);
        long stored = 0L;
        long capacity = 0L;
        for (ItemStack stack : itemStacks) {
            IOxygenCharger oxygenCharger;
            if (stack.m_41619_() || (oxygenCharger = OxygenChargerUtils.getOxygenCharger(stack)) == null || oxygenCharger.getChargeMode() == ChargeMode.NONE) continue;
            IOxygenStorage oxygenStorage = oxygenCharger.getOxygenStorage();
            stored = Math.min(stored + (long)oxygenStorage.getOxygenStored(), Integer.MAX_VALUE);
            capacity = Math.min(capacity + (long)oxygenStorage.getMaxOxygenStored(), Integer.MAX_VALUE);
        }
        OxygenCanItem item = (OxygenCanItem)AddonItems.OXYGEN_CAN.get();
        return new GaugeValueSimple(item.getRegistryName(), (int)stored, (int)capacity, item.m_7626_(item.m_7968_()));
    }

    public static IOxygenCharger firstExtractableOxygenCharger(LivingEntity entity, int extracting, ItemStack beContains) {
        return OxygenChargerUtils.streamExtractableOxygenCharger(entity, extracting, beContains).findFirst().orElse(null);
    }

    public static Stream<IOxygenCharger> streamExtractableOxygenCharger(LivingEntity entity, int extracting, ItemStack beContains) {
        return OxygenChargerUtils.streamExtractableItems(entity, extracting, beContains).map(OxygenChargerUtils::getOxygenCharger);
    }

    public static ItemStack firstExtractableItem(LivingEntity entity, int extracting, ItemStack beContains) {
        return OxygenChargerUtils.streamExtractableItems(entity, extracting, beContains).findFirst().orElse(ItemStack.f_41583_);
    }

    public static Stream<ItemStack> streamExtractableItems(LivingEntity entity, int extracting, ItemStack beContains) {
        return LivingEntityHelper.getInventoryStacks(entity).stream().filter(is -> {
            IOxygenCharger oxygenCharger = OxygenChargerUtils.getOxygenCharger(is);
            if (oxygenCharger != null && Iterables.contains(oxygenCharger.getChargeMode().getItemStacks((Entity)entity), (Object)beContains)) {
                IOxygenStorage oxygenStorage = oxygenCharger.getOxygenStorage();
                return oxygenStorage.extractOxygen(extracting, true) == extracting;
            }
            return false;
        });
    }

    public static IOxygenCharger getOxygenCharger(ItemStack is) {
        return (IOxygenCharger)is.getCapability(CapabilityOxygenCharger.OXYGEN_CHARGER).orElse(null);
    }

    private OxygenChargerUtils() {
    }
}

