/*
 * Decompiled with CFR 0.152.
 */
package beyond_earth_giselle_addon.common.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.mrscauthd.beyond_earth.ModInit;
import net.mrscauthd.beyond_earth.capability.oxygen.OxygenUtil;

public class AddonCommand {
    private AddonCommand() {
    }

    public static LiteralArgumentBuilder<CommandSourceStack> builder() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"bega").then(PlanetSelection.builder())).then(Equip.builder());
    }

    public static boolean isPlayerHasPermission(CommandSourceStack cs, int permission) {
        return cs.m_6761_(2) && cs.m_81373_() instanceof ServerPlayer;
    }

    public static boolean isPlayerHasPermission2(CommandSourceStack cs) {
        return AddonCommand.isPlayerHasPermission(cs, 2);
    }

    public static int sendEquipedMessage(CommandSourceStack source) {
        source.m_81354_((Component)new TextComponent("Equipped"), false);
        return 0;
    }

    private static class PlanetSelection {
        private PlanetSelection() {
        }

        public static LiteralArgumentBuilder<CommandSourceStack> builder() {
            return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"planetselection").requires(AddonCommand::isPlayerHasPermission2)).executes(PlanetSelection::execute);
        }

        public static int execute(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerPlayer player = source.m_81375_();
            CompoundTag persistentData = player.getPersistentData();
            persistentData.m_128379_("beyond_earth:planet_selection_gui_open", true);
            persistentData.m_128359_("beyond_earth:rocket_type", ((EntityType)ModInit.TIER_4_ROCKET.get()).m_20675_());
            persistentData.m_128359_("beyond_earth:slot0", Items.f_41852_.getRegistryName().toString());
            return 0;
        }
    }

    private static class Equip {
        private Equip() {
        }

        public static LiteralArgumentBuilder<CommandSourceStack> builder() {
            return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"equip").requires(AddonCommand::isPlayerHasPermission2)).then(Commands.m_82127_((String)"spacesuit1").executes(Equip::spacesuit1))).then(Commands.m_82127_((String)"spacesuit2").executes(Equip::spacesuit2));
        }

        public static int spacesuit1(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerPlayer player = source.m_81375_();
            player.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)ModInit.OXYGEN_MASK.get()));
            player.m_8061_(EquipmentSlot.CHEST, OxygenUtil.makeFull((ItemStack)new ItemStack((ItemLike)ModInit.SPACE_SUIT.get())));
            player.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)ModInit.SPACE_PANTS.get()));
            player.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)ModInit.SPACE_BOOTS.get()));
            return AddonCommand.sendEquipedMessage(source);
        }

        public static int spacesuit2(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerPlayer player = source.m_81375_();
            player.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)ModInit.NETHERITE_OXYGEN_MASK.get()));
            player.m_8061_(EquipmentSlot.CHEST, OxygenUtil.makeFull((ItemStack)new ItemStack((ItemLike)ModInit.NETHERITE_SPACE_SUIT.get())));
            player.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)ModInit.NETHERITE_SPACE_PANTS.get()));
            player.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)ModInit.NETHERITE_SPACE_BOOTS.get()));
            return AddonCommand.sendEquipedMessage(source);
        }
    }
}

