/*
 * Decompiled with CFR 0.152.
 */
package beyond_earth_giselle_addon.common.compat.jaopca;

import beyond_earth_giselle_addon.common.compat.jaopca.AddonJaopcaCompat;
import beyond_earth_giselle_addon.common.compat.jaopca.JaopcaModule;
import java.util.function.ToIntFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import slimeknights.tconstruct.library.recipe.melting.IMeltingRecipe;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.helpers.IMiscHelper;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.tconstruct.TConstructHelper;

@JAOPCAModule(modDependencies={"tconstruct"})
public class JaopcaModuleCompatTinkers
implements IModule {
    public String getName() {
        return "beyond_earth_giselle_addon_compat_tinkers";
    }

    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        JAOPCAApi api = JAOPCAApi.instance();
        IForm compressedsForm = api.getForm("beyond_earth_compresseds");
        for (IMaterial material : compressedsForm.getMaterials()) {
            this.registerCompressedsMeltingRecipe(material, compressedsForm, "compresseds");
        }
    }

    public void registerCompressedsMeltingRecipe(IMaterial material, IForm form, String suffix) {
        JAOPCAApi api = JAOPCAApi.instance();
        IMiscHelper miscHelper = api.miscHelper();
        String name = material.getName();
        ResourceLocation compressedsTag = miscHelper.getTagLocation(JaopcaModule.COMPRESSEDS_TAG, name);
        ResourceLocation moltenLocation = miscHelper.getTagLocation("molten", name, "_");
        if (!api.getItemTags().contains(compressedsTag) || !api.getFluidTags().contains(moltenLocation)) {
            return;
        }
        int ingots = 1;
        ResourceLocation id = AddonJaopcaCompat.rl("beyond_earth.smeltery.melting." + name + "_" + suffix);
        ToIntFunction<FluidStack> tempFunction = stack -> stack.getFluid().getAttributes().getTemperature(stack) - 300;
        ToIntFunction<FluidStack> moltenTime = stack -> IMeltingRecipe.calcTime((int)tempFunction.applyAsInt((FluidStack)stack), (float)ingots);
        TConstructHelper tinkerHelper = TConstructHelper.INSTANCE;
        tinkerHelper.registerMeltingRecipe(id, (Object)compressedsTag, (Object)moltenLocation, 90 * ingots, tempFunction, moltenTime, new Object[0]);
    }
}

