/*
 * Decompiled with CFR 0.152.
 */
package beyond_earth_giselle_addon.common.compat.jei;

import beyond_earth_giselle_addon.client.gui.AdvancedCompressorScreen;
import beyond_earth_giselle_addon.client.gui.ElectricBlastFurnaceScreen;
import beyond_earth_giselle_addon.common.BeyondEarthAddon;
import beyond_earth_giselle_addon.common.compat.jei.IItemStackToitemStackRegistration;
import beyond_earth_giselle_addon.common.compat.jei.ItemStackToItemStackRegistration;
import beyond_earth_giselle_addon.common.compat.jei.RecipeCategory;
import beyond_earth_giselle_addon.common.compat.jei.RecipeCategoryFuelLoader;
import beyond_earth_giselle_addon.common.compat.jei.RecipeCategoryItemStackToItemStack;
import beyond_earth_giselle_addon.common.config.AddonConfigs;
import beyond_earth_giselle_addon.common.inventory.AdvancedCompressorContainerMenu;
import beyond_earth_giselle_addon.common.inventory.ElectricBlastFurnaceContainerMenu;
import beyond_earth_giselle_addon.common.item.crafting.ExtrudingRecipe;
import beyond_earth_giselle_addon.common.item.crafting.RollingRecipe;
import beyond_earth_giselle_addon.common.registries.AddonBlocks;
import beyond_earth_giselle_addon.common.registries.AddonRecipes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.mrscauthd.beyond_earth.ModInit;
import net.mrscauthd.beyond_earth.crafting.ItemStackToItemStackRecipeType;
import net.mrscauthd.beyond_earth.gui.helper.GuiHelper;
import net.mrscauthd.beyond_earth.jei.JeiPlugin;

@JeiPlugin
public class AddonJeiPlugin
implements IModPlugin {
    public static final String JEI_CATEGORY = "jei.category";
    public static final String JEI_INFO = "jei.info";
    private static AddonJeiPlugin instance;
    private List<IItemStackToitemStackRegistration<?, ?>> is2isRegistrations;
    private IItemStackToitemStackRegistration<ElectricBlastFurnaceScreen, ElectricBlastFurnaceContainerMenu> electricBlastFurnace;
    private IItemStackToitemStackRegistration<AdvancedCompressorScreen, AdvancedCompressorContainerMenu> advancedCompressor;
    private List<RecipeCategory<?>> categoires;
    private RecipeCategory<RollingRecipe> rollingCategory;
    private RecipeCategory<ExtrudingRecipe> extrudingCategory;
    private RecipeCategoryFuelLoader fuelLoaderCategory;
    private IDrawable fluidOverlay;

    public static AddonJeiPlugin instance() {
        return instance;
    }

    public static final ResourceLocation createUid(ResourceLocation key) {
        return new ResourceLocation(key.m_135827_(), "jei.category." + key.m_135815_());
    }

    public static final Component getCategoryTitle(ResourceLocation key) {
        return new TranslatableComponent("jei.category." + key.m_135827_() + "." + key.m_135815_());
    }

    public AddonJeiPlugin() {
        instance = this;
        this.categoires = new ArrayList();
        this.rollingCategory = new RecipeCategoryItemStackToItemStack<ItemStackToItemStackRecipeType<RollingRecipe>, RollingRecipe>(RollingRecipe.class, AddonRecipes.ROLLING);
        this.categoires.add(this.rollingCategory);
        this.extrudingCategory = new RecipeCategoryItemStackToItemStack<ItemStackToItemStackRecipeType<ExtrudingRecipe>, ExtrudingRecipe>(ExtrudingRecipe.class, AddonRecipes.EXTRUDING);
        this.categoires.add(this.extrudingCategory);
        this.fuelLoaderCategory = new RecipeCategoryFuelLoader((Class<? extends Fluid>)Fluid.class);
        this.categoires.add(this.fuelLoaderCategory);
        this.is2isRegistrations = new ArrayList();
        this.electricBlastFurnace = new ItemStackToItemStackRegistration(ElectricBlastFurnaceScreen.class, ElectricBlastFurnaceContainerMenu.class);
        this.is2isRegistrations.add(this.electricBlastFurnace);
        this.electricBlastFurnace.getCategories().add(VanillaRecipeCategoryUid.BLASTING);
        this.electricBlastFurnace.getItemstacks().add(new ItemStack((ItemLike)AddonBlocks.ELECTRIC_BLAST_FURNACE.get()));
        this.advancedCompressor = new ItemStackToItemStackRegistration(AdvancedCompressorScreen.class, AdvancedCompressorContainerMenu.class);
        this.is2isRegistrations.add(this.advancedCompressor);
        this.advancedCompressor.getCategories().add(JeiPlugin.CompressorJeiCategory.Uid);
        this.advancedCompressor.getCategories().add(this.getRollingCategory().getUid());
        this.advancedCompressor.getCategories().add(this.getExtrudingCategory().getUid());
        this.advancedCompressor.getItemstacks().add(new ItemStack((ItemLike)AddonBlocks.ADVANCED_COMPRESSOR.get()));
    }

    public ResourceLocation getPluginUid() {
        return BeyondEarthAddon.rl("jei");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        this.fluidOverlay = guiHelper.drawableBuilder(GuiHelper.FLUID_TANK_PATH, 0, 0, 14, 48).setTextureSize(14, 48).build();
        for (RecipeCategory<?> recipeCategory : this.getCategoires()) {
            recipeCategory.createGui(guiHelper);
            registration.addRecipeCategories(new IRecipeCategory[]{recipeCategory});
        }
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        for (RecipeCategory<?> recipeCategory : this.getCategoires()) {
            recipeCategory.addRecipeTransferHandler(registration);
        }
        for (IItemStackToitemStackRegistration iItemStackToitemStackRegistration : this.getItemStackToItemStackRegistrations()) {
            iItemStackToitemStackRegistration.addRecipeTransferHandler(registration);
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        for (RecipeCategory<?> recipeCategory : this.getCategoires()) {
            recipeCategory.registerRecipeCatalysts(registration);
        }
        for (IItemStackToitemStackRegistration iItemStackToitemStackRegistration : this.getItemStackToItemStackRegistrations()) {
            iItemStackToitemStackRegistration.registerRecipeCatalysts(registration);
        }
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        for (RecipeCategory<?> recipeCategory : this.getCategoires()) {
            recipeCategory.registerGuiHandlers(registration);
        }
        for (IItemStackToitemStackRegistration iItemStackToitemStackRegistration : this.getItemStackToItemStackRegistrations()) {
            iItemStackToitemStackRegistration.registerGuiHandlers(registration);
        }
    }

    public void registerRecipes(IRecipeRegistration registration) {
        for (RecipeCategory<?> recipeCategory : this.getCategoires()) {
            recipeCategory.registerRecipes(registration);
        }
        this.addIngredientInfo(registration, (ItemLike)AddonBlocks.FUEL_LOADER.get(), AddonConfigs.Common.machines.fuelLoader_range.get(), ModInit.FLUID_VEHICLE_FUEL_TAG.toString());
        this.addIngredientInfo(registration, (ItemLike)AddonBlocks.GRAVITY_NORMALIZER.get(), new Object[0]);
    }

    public void addIngredientInfo(IRecipeRegistration registration, ItemLike itemLike, Object ... objects) {
        registration.addIngredientInfo((Object)new ItemStack(itemLike), VanillaTypes.ITEM, new Component[]{new TranslatableComponent(BeyondEarthAddon.tl(JEI_INFO, itemLike.m_5456_().getRegistryName()), objects)});
    }

    public List<IItemStackToitemStackRegistration<?, ?>> getItemStackToItemStackRegistrations() {
        return this.is2isRegistrations;
    }

    public List<RecipeCategory<?>> getCategoires() {
        return Collections.unmodifiableList(this.categoires);
    }

    public RecipeCategory<RollingRecipe> getRollingCategory() {
        return this.rollingCategory;
    }

    public RecipeCategory<ExtrudingRecipe> getExtrudingCategory() {
        return this.extrudingCategory;
    }

    public RecipeCategoryFuelLoader getFuelLoaderCategory() {
        return this.fuelLoaderCategory;
    }

    public IDrawable getFluidOverlay() {
        return this.fluidOverlay;
    }
}

