/*
 * Decompiled with CFR 0.152.
 */
package beyond_earth_giselle_addon.common.compat.jei;

import beyond_earth_giselle_addon.common.compat.jei.AddonJeiPlugin;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public abstract class RecipeCategory<R>
implements IRecipeCategory<R> {
    private final Class<? extends R> recipeClass;

    public RecipeCategory(Class<? extends R> recipeClass) {
        this.recipeClass = recipeClass;
    }

    public abstract IDrawable getBackground();

    public abstract ResourceLocation getKey();

    public Class<? extends R> getRecipeClass() {
        return this.recipeClass;
    }

    public ResourceLocation getUid() {
        return AddonJeiPlugin.createUid(this.getKey());
    }

    public Component getTitle() {
        return AddonJeiPlugin.getCategoryTitle(this.getKey());
    }

    public IDrawable getIcon() {
        return null;
    }

    public void createGui(IGuiHelper guiHelper) {
    }

    public void registerRecipes(IRecipeRegistration registration) {
    }

    public void addRecipeTransferHandler(IRecipeTransferRegistration registration) {
    }

    public List<ItemStack> getRecipeCatalystItemStacks() {
        return new ArrayList<ItemStack>();
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        ResourceLocation uid = this.getUid();
        for (ItemStack itemStack : this.getRecipeCatalystItemStacks()) {
            registration.addRecipeCatalyst(itemStack, new ResourceLocation[]{uid});
        }
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
    }
}

