/*
 * Decompiled with CFR 0.152.
 */
package beyond_earth_giselle_addon.common.compat.jei;

import beyond_earth_giselle_addon.client.gui.FuelLoaderScreen;
import beyond_earth_giselle_addon.common.BeyondEarthAddon;
import beyond_earth_giselle_addon.common.compat.jei.AddonJeiPlugin;
import beyond_earth_giselle_addon.common.compat.jei.FuelLoaderGuiContainerHandler;
import beyond_earth_giselle_addon.common.compat.jei.RecipeCategory;
import beyond_earth_giselle_addon.common.config.AddonConfigs;
import beyond_earth_giselle_addon.common.registries.AddonBlocks;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.mrscauthd.beyond_earth.ModInit;
import net.mrscauthd.beyond_earth.events.Methods;

public class RecipeCategoryFuelLoader
extends RecipeCategory<Fluid> {
    public static final ResourceLocation BACKGROUND_LOCATION = BeyondEarthAddon.rl("textures/jei/fuel_loader.png");
    public static final int BACKGROUND_WIDTH = 144;
    public static final int BACKGROUND_HEIGHT = 84;
    public static final int TANK_LEFT = 55;
    public static final int TANK_TOP = 18;
    private IDrawable background;

    public static IDrawable createBackground(IGuiHelper guiHelper) {
        return guiHelper.createDrawable(BACKGROUND_LOCATION, 0, 0, 144, 84);
    }

    public RecipeCategoryFuelLoader(Class<? extends Fluid> recipeClass) {
        super(recipeClass);
    }

    @Override
    public void createGui(IGuiHelper guiHelper) {
        super.createGui(guiHelper);
        this.background = RecipeCategoryFuelLoader.createBackground(guiHelper);
    }

    @Override
    public IDrawable getBackground() {
        return this.background;
    }

    public void setIngredients(Fluid recipe, IIngredients ingredients) {
        int capacity = (Integer)AddonConfigs.Common.machines.fuelLoader_capacity.get();
        ingredients.setInputs(VanillaTypes.FLUID, Collections.singletonList(new FluidStack(recipe, capacity)));
    }

    public void setRecipe(IRecipeLayout recipeLayout, Fluid recipe, IIngredients ingredients) {
        int capacity = (Integer)AddonConfigs.Common.machines.fuelLoader_capacity.get();
        IGuiFluidStackGroup fluidStacks = recipeLayout.getFluidStacks();
        fluidStacks.init(0, true, 55, 18, 14, 48, capacity, false, AddonJeiPlugin.instance().getFluidOverlay());
        fluidStacks.set(0, (List)ingredients.getInputs(VanillaTypes.FLUID).get(0));
    }

    public boolean testFluid(Fluid fluid) {
        return Methods.tagCheck((Fluid)fluid, (ResourceLocation)ModInit.FLUID_VEHICLE_FUEL_TAG) && fluid.m_7444_(fluid.m_76145_());
    }

    @Override
    public List<ItemStack> getRecipeCatalystItemStacks() {
        List<ItemStack> list = super.getRecipeCatalystItemStacks();
        list.add(new ItemStack((ItemLike)AddonBlocks.FUEL_LOADER.get()));
        return list;
    }

    @Override
    public void registerRecipes(IRecipeRegistration registration) {
        super.registerRecipes(registration);
        registration.addRecipes((Collection)ForgeRegistries.FLUIDS.getValues().stream().filter(this::testFluid).collect(Collectors.toList()), this.getUid());
    }

    @Override
    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        super.registerGuiHandlers(registration);
        registration.addGuiContainerHandler(FuelLoaderScreen.class, (IGuiContainerHandler)new FuelLoaderGuiContainerHandler());
    }

    @Override
    public ResourceLocation getKey() {
        return AddonBlocks.FUEL_LOADER.getId();
    }
}

