/*
 * Decompiled with CFR 0.152.
 */
package beyond_earth_giselle_addon.common.compat.jer;

import beyond_earth_giselle_addon.common.BeyondEarthAddon;
import beyond_earth_giselle_addon.common.compat.jei.AddonJeiPlugin;
import beyond_earth_giselle_addon.common.compat.jer.AlienTradeList;
import beyond_earth_giselle_addon.common.compat.jer.AlienWrapper;
import javax.annotation.Nonnull;
import jeresources.jei.BlankJEIRecipeCategory;
import jeresources.reference.Resources;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class AlienCategory
extends BlankJEIRecipeCategory<AlienWrapper> {
    public static final ResourceLocation KEY = BeyondEarthAddon.rl("alien_trading");
    public static final ResourceLocation Uid = AddonJeiPlugin.createUid(KEY);
    protected static final int X_FIRST_ITEM = 95;
    protected static final int X_ITEM_DISTANCE = 18;
    protected static final int X_ITEM_RESULT = 150;
    protected static final int Y_ITEM_DISTANCE = 22;

    public AlienCategory(IGuiHelper guiHelper) {
        super((IDrawable)guiHelper.createDrawable(Resources.Gui.Jei.TABS, 0, 0, 16, 16));
    }

    @Nonnull
    public ResourceLocation getUid() {
        return Uid;
    }

    @Nonnull
    public Component getTitle() {
        return AddonJeiPlugin.getCategoryTitle(KEY);
    }

    @Nonnull
    public IDrawable getBackground() {
        return Resources.Gui.Jei.VILLAGER;
    }

    public Class<? extends AlienWrapper> getRecipeClass() {
        return AlienWrapper.class;
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull AlienWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        int i;
        IFocus focus = recipeLayout.getFocus(VanillaTypes.ITEM);
        recipeWrapper.setFocus((IFocus<ItemStack>)focus);
        if (recipeWrapper.hasPois()) {
            recipeLayout.getItemStacks().init(0, true, 49, 18);
            recipeLayout.getItemStacks().set(0, recipeWrapper.getPois());
        }
        int y = 22 * (6 - recipeWrapper.getPossibleLevels((IFocus<ItemStack>)focus).size()) / 2;
        for (i = 0; i < recipeWrapper.getPossibleLevels((IFocus<ItemStack>)focus).size(); ++i) {
            recipeLayout.getItemStacks().init(3 * i + 1, true, 95, y + i * 22);
            recipeLayout.getItemStacks().init(3 * i + 2, true, 113, y + i * 22);
            recipeLayout.getItemStacks().init(3 * i + 3, false, 150, y + i * 22);
        }
        i = 0;
        for (int level : recipeWrapper.getPossibleLevels((IFocus<ItemStack>)focus)) {
            AlienTradeList tradeList = recipeWrapper.getTrades(level).getFocusedList((IFocus<ItemStack>)focus);
            recipeLayout.getItemStacks().set(3 * i + 1, tradeList.getCostAs());
            recipeLayout.getItemStacks().set(3 * i + 2, tradeList.getCostBs());
            recipeLayout.getItemStacks().set(3 * i + 3, tradeList.getResults());
            ++i;
        }
    }
}

