/*
 * Decompiled with CFR 0.152.
 */
package beyond_earth_giselle_addon.common.compat.jer;

import beyond_earth_giselle_addon.common.compat.jer.AlienTradeList;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.recipe.IFocus;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.mrscauthd.beyond_earth.entity.alien.AlienEntity;

public class AlienEntry {
    protected final List<AlienTradeList> tradeList;
    protected final VillagerProfession profession;
    protected final AlienEntity alienEntity;

    public AlienEntry(VillagerProfession profession, Int2ObjectMap<VillagerTrades.ItemListing[]> tradesLists, AlienEntity alienEntity) {
        this.profession = profession;
        this.tradeList = new LinkedList<AlienTradeList>();
        this.alienEntity = alienEntity;
        this.addItemListingLists(tradesLists);
    }

    public void addItemListingLists(Int2ObjectMap<VillagerTrades.ItemListing[]> tradesLists) {
        for (int i = 1; i < tradesLists.size() + 1; ++i) {
            VillagerTrades.ItemListing[] levelList = (VillagerTrades.ItemListing[])tradesLists.get(i);
            AlienTradeList trades = this.tradeList.size() > i ? this.tradeList.get(i) : new AlienTradeList(this);
            trades.addItemListingList(levelList);
            this.tradeList.add(trades);
        }
    }

    public AlienTradeList getAlienTrade(int level) {
        if (this.tradeList.size() > level) {
            return this.tradeList.get(level);
        }
        return new AlienTradeList(null);
    }

    public List<ItemStack> getInputs() {
        LinkedList<ItemStack> list = new LinkedList<ItemStack>();
        for (List list2 : this.tradeList) {
            for (AlienTradeList.Trade trade : list2) {
                list.add(trade.getMinCostA());
                if (trade.getMinCostB().m_41619_()) continue;
                list.add(trade.getMinCostB());
            }
        }
        return list;
    }

    public List<ItemStack> getOutputs() {
        LinkedList<ItemStack> list = new LinkedList<ItemStack>();
        for (List list2 : this.tradeList) {
            list.addAll(list2.stream().map(AlienTradeList.Trade::getMinResult).collect(Collectors.toList()));
        }
        return list;
    }

    public int getMaxLevel() {
        return this.tradeList.size();
    }

    public String getName() {
        return this.profession.toString();
    }

    public String getDisplayName() {
        return "entity.beyond_earth.alien." + this.profession.toString();
    }

    public VillagerProfession getProfession() {
        return this.profession;
    }

    public List<Integer> getPossibleLevels(IFocus<ItemStack> focus) {
        ArrayList<Integer> levels = new ArrayList<Integer>();
        for (int i = 0; i < this.tradeList.size(); ++i) {
            if (this.tradeList.get(i) == null || this.tradeList.get(i).getFocusedList(focus).size() <= 0) continue;
            levels.add(i);
        }
        return levels;
    }

    public AlienEntity getAlienEntity() {
        return this.alienEntity;
    }

    public String toString() {
        return this.getName();
    }

    public List<ItemStack> getPois() {
        return this.profession.m_35622_().getBlockStates().stream().map(blockstate -> new ItemStack((ItemLike)blockstate.m_60734_())).collect(Collectors.toList());
    }

    public boolean hasPois() {
        return !this.profession.m_35622_().getBlockStates().isEmpty();
    }
}

