/*
 * Decompiled with CFR 0.152.
 */
package beyond_earth_giselle_addon.common.compat.jer;

import beyond_earth_giselle_addon.common.BeyondEarthAddon;
import beyond_earth_giselle_addon.common.compat.jer.AlienCategory;
import beyond_earth_giselle_addon.common.compat.jer.AlienEntry;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import mezz.jei.api.recipe.IFocus;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;

public class AlienTradeList
extends LinkedList<Trade> {
    private static final long serialVersionUID = 1L;
    private AlienEntry villagerEntry;

    public AlienTradeList(AlienEntry villagerEntry) {
        this.villagerEntry = villagerEntry;
    }

    public List<ItemStack> getCostAs() {
        return this.stream().map(Trade::getMinCostA).collect(Collectors.toList());
    }

    public List<ItemStack> getCostBs() {
        List<ItemStack> costBs = this.stream().map(Trade::getMinCostB).collect(Collectors.toList());
        return costBs.stream().allMatch(ItemStack::m_41619_) ? new ArrayList() : this.orElseBarrier(costBs);
    }

    private List<ItemStack> orElseBarrier(List<ItemStack> costBs) {
        return costBs.stream().map(AlienTradeList::orElseBarrier).collect(Collectors.toList());
    }

    public static ItemStack orElseBarrier(ItemStack is) {
        return is.m_41619_() ? AlienTradeList.getNotNeededItem() : is;
    }

    public static ItemStack getNotNeededItem() {
        ItemStack itemStack = new ItemStack((ItemLike)Items.f_42127_);
        itemStack.m_41714_((Component)new TranslatableComponent(BeyondEarthAddon.tl("jer.text", AlienCategory.KEY, "notneeded")));
        return itemStack;
    }

    public List<ItemStack> getResults() {
        return this.stream().map(Trade::getMinResult).collect(Collectors.toList());
    }

    public AlienTradeList getSubListSell(ItemStack itemStack) {
        return this.stream().filter(trade -> trade.sellsItem(itemStack)).collect(Collectors.toCollection(() -> new AlienTradeList(this.villagerEntry)));
    }

    public AlienTradeList getSubListBuy(ItemStack itemStack) {
        return this.stream().filter(trade -> trade.buysItem(itemStack)).collect(Collectors.toCollection(() -> new AlienTradeList(this.villagerEntry)));
    }

    public AlienTradeList getFocusedList(IFocus<ItemStack> focus) {
        if (focus == null) {
            return this;
        }
        switch (focus.getMode()) {
            case INPUT: {
                return this.getSubListBuy((ItemStack)focus.getValue());
            }
            case OUTPUT: {
                return this.getSubListSell((ItemStack)focus.getValue());
            }
        }
        return this;
    }

    private void addMerchantRecipe(MerchantOffers merchantOffers, VillagerTrades.ItemListing trade, Random rand) {
        MerchantOffer offer = trade.m_5670_((Entity)this.villagerEntry.getAlienEntity(), rand);
        if (offer != null) {
            merchantOffers.add((Object)offer);
        }
    }

    public void addItemListingList(VillagerTrades.ItemListing[] tradeList) {
        for (VillagerTrades.ItemListing trade : tradeList) {
            int maxResult;
            int minCostB;
            int maxCostB;
            int maxCostA;
            MerchantOffers tempList = new MerchantOffers();
            Random rand = new Random();
            for (int itr = 0; itr < 100; ++itr) {
                this.addMerchantRecipe(tempList, trade, rand);
            }
            if (tempList.size() == 0) {
                return;
            }
            ItemStack costA = ((MerchantOffer)tempList.get(0)).m_45358_();
            ItemStack costB = ((MerchantOffer)tempList.get(0)).m_45364_();
            ItemStack result = ((MerchantOffer)tempList.get(0)).m_45368_();
            int minCostA = maxCostA = costA.m_41613_();
            if (!costB.m_41619_()) {
                minCostB = maxCostB = costB.m_41613_();
            } else {
                maxCostB = 1;
                minCostB = 1;
            }
            int minResult = maxResult = result.m_41613_();
            for (MerchantOffer merchantRecipe : tempList) {
                if (minCostA > merchantRecipe.m_45352_().m_41613_()) {
                    minCostA = merchantRecipe.m_45358_().m_41613_();
                }
                if (!costB.m_41619_() && minCostB > merchantRecipe.m_45364_().m_41613_()) {
                    minCostB = merchantRecipe.m_45364_().m_41613_();
                }
                if (minResult > merchantRecipe.m_45368_().m_41613_()) {
                    minResult = merchantRecipe.m_45368_().m_41613_();
                }
                if (maxCostA < merchantRecipe.m_45358_().m_41613_()) {
                    maxCostA = merchantRecipe.m_45358_().m_41613_();
                }
                if (!costB.m_41619_() && maxCostB < merchantRecipe.m_45364_().m_41613_()) {
                    maxCostB = merchantRecipe.m_45358_().m_41613_();
                }
                if (maxResult >= merchantRecipe.m_45368_().m_41613_()) continue;
                maxResult = merchantRecipe.m_45368_().m_41613_();
            }
            this.add(new Trade(costA, minCostA, maxCostA, costB, minCostB, maxCostB, result, minResult, maxResult));
        }
    }

    public static class Trade {
        private final ItemStack costA;
        private final ItemStack costB;
        private final ItemStack result;
        private final int minCostA;
        private final int minCostB;
        private final int minResult;
        private final int maxCostA;
        private final int maxCostB;
        private final int maxResult;

        Trade(ItemStack costA, int minCostA, int maxCostA, ItemStack costB, int minCostB, int maxCostB, ItemStack result, int minResult, int maxResult) {
            this.costA = costA;
            this.minCostA = minCostA;
            this.maxCostA = maxCostA;
            this.costB = costB;
            this.minCostB = minCostB;
            this.maxCostB = maxCostB;
            this.result = result;
            this.minResult = minResult;
            this.maxResult = maxResult;
        }

        public boolean sellsItem(ItemStack itemStack) {
            return this.result.m_41656_(itemStack);
        }

        public boolean buysItem(ItemStack itemStack) {
            return this.costA.m_41656_(itemStack) || !this.costB.m_41619_() && this.costB.m_41656_(itemStack);
        }

        public ItemStack getMinCostA() {
            ItemStack minBuyStack = this.costA.m_41777_();
            minBuyStack.m_41764_(this.minCostA);
            return minBuyStack;
        }

        public ItemStack getMinCostB() {
            if (this.costB == null) {
                return ItemStack.f_41583_;
            }
            ItemStack minBuyStack = this.costB.m_41777_();
            minBuyStack.m_41764_(this.minCostB);
            return minBuyStack;
        }

        public ItemStack getMinResult() {
            ItemStack minSellStack = this.result.m_41777_();
            minSellStack.m_41764_(this.minResult);
            return minSellStack;
        }

        public ItemStack getMaxCostA() {
            ItemStack maxBuyStack = this.costA.m_41777_();
            maxBuyStack.m_41764_(this.maxCostA);
            return maxBuyStack;
        }

        public ItemStack getMaxCostB() {
            if (this.costB == null) {
                return ItemStack.f_41583_;
            }
            ItemStack maxBuyStack = this.costB.m_41777_();
            maxBuyStack.m_41764_(this.maxCostB);
            return maxBuyStack;
        }

        public ItemStack getMaxResult() {
            ItemStack maxSellStack = this.result.m_41777_();
            maxSellStack.m_41764_(this.maxResult);
            return maxSellStack;
        }

        public String toString() {
            return "Buy1: " + this.costA + ", Buy2: " + this.costB + ", Sell: " + this.result;
        }
    }
}

