/*
 * Decompiled with CFR 0.152.
 */
package beyond_earth_giselle_addon.common.compat.jer;

import beyond_earth_giselle_addon.common.compat.jer.DistributionShape;
import beyond_earth_giselle_addon.common.compat.jer.OreGenHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import jeresources.api.IWorldGenRegistry;
import jeresources.api.distributions.DistributionBase;
import jeresources.api.distributions.DistributionCustom;
import jeresources.api.drop.LootDrop;
import jeresources.api.restrictions.Restriction;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;

public class OreGenBuilder {
    public Block block;
    public int veinSize;
    public int veinCountPerChunk;
    public final List<DistributionShape> distributionShapes = new ArrayList<DistributionShape>();
    public Restriction restriction;
    public boolean silkTouch;
    public final List<LootDrop> drops = new ArrayList<LootDrop>();

    public OreGenBuilder defaultDrops() {
        return this.defaultDrops(false);
    }

    public OreGenBuilder defaultDrops(boolean silkTouch) {
        this.silkTouch = silkTouch;
        this.drops.clear();
        this.drops.add(new LootDrop(this.getItemStack()));
        return this;
    }

    public void register(IWorldGenRegistry registry) {
        List<DistributionShape> distributionShapes = this.distributionShapes;
        if (distributionShapes.size() == 0) {
            registry.register(this.getItemStack(), (DistributionBase)new DistributionCustom(new float[0]), this.restriction, this.silkTouch, this.drops.toArray(new LootDrop[0]));
        } else {
            for (DistributionShape shape : distributionShapes) {
                DistributionBase distribution = shape.build(this);
                registry.register(this.getItemStack(), distribution, this.restriction, this.silkTouch, this.drops.toArray(new LootDrop[0]));
            }
        }
    }

    private ItemStack getItemStack() {
        return new ItemStack((ItemLike)this.block);
    }

    public OreGenBuilder placedFeature(PlacedFeature placedFeature) {
        List placements = placedFeature.m_197216_();
        List children = placedFeature.m_191781_().collect(Collectors.toList());
        for (PlacementModifier placementModifier : placements) {
            this.placementModifier(placementModifier);
        }
        for (ConfiguredFeature child : children) {
            this.featureConfig(child.m_65397_());
        }
        return this;
    }

    public OreGenBuilder featureConfig(FeatureConfiguration config) {
        if (config instanceof OreConfiguration) {
            OreConfiguration oreConfig = (OreConfiguration)config;
            this.block = ((OreConfiguration.TargetBlockState)oreConfig.f_161005_.get((int)0)).f_161033_.m_60734_();
            this.veinSize = oreConfig.f_67839_;
        }
        return this;
    }

    public OreGenBuilder placementModifier(PlacementModifier placementModifier) {
        if (placementModifier instanceof CountPlacement) {
            IntProvider intProvider = OreGenHelper.getCountPlacementCount((CountPlacement)placementModifier);
            this.veinCountPerChunk = intProvider.m_142739_();
        } else if (placementModifier instanceof HeightRangePlacement) {
            DistributionShape shape = OreGenHelper.getHeightRangePlacementShape((HeightRangePlacement)placementModifier);
            this.distributionShapes.add(shape);
        }
        return this;
    }
}

