/*
 * Decompiled with CFR 0.152.
 */
package beyond_earth_giselle_addon.common.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class MekanismConfig {
    public final ForgeConfigSpec.ConfigValue<Integer> mekaSuitHelmet_OxygenCapacity;
    public final ForgeConfigSpec.ConfigValue<Integer> mekaSuitHelmet_OxygenTransfer;
    public final ForgeConfigSpec.ConfigValue<Integer> moduleSpaceBreathing_maxProduceRate;
    public final ForgeConfigSpec.ConfigValue<Integer> moduleSpaceBreathing_oxygenUsing;
    public final ForgeConfigSpec.ConfigValue<Integer> moduleSpaceBreathing_oxygenDuration;
    public final ForgeConfigSpec.ConfigValue<Integer> moduleSpaceBreathing_energyUsing;
    public final ForgeConfigSpec.ConfigValue<Integer> moduleSpaceFireProof_energyUsing;
    public final ForgeConfigSpec.ConfigValue<Integer> moduleVenusAcidProof_energyUsing;
    public final ForgeConfigSpec.ConfigValue<Integer> moduleSpaceGravityNormalizing_energyUsing;
    public final ForgeConfigSpec.ConfigValue<Boolean> moduleGravitationalModulating_normalizable;
    public final ForgeConfigSpec.ConfigValue<Integer> moduleGravitationalModulating_energyUsing;

    public MekanismConfig(ForgeConfigSpec.Builder builder) {
        builder.push("mekasuit_helmet");
        this.mekaSuitHelmet_OxygenCapacity = builder.define("oxygenCapacity", (Object)48000);
        this.mekaSuitHelmet_OxygenTransfer = builder.define("oxygenTransfer", (Object)256);
        builder.pop();
        builder.push("module_space_breathing_unit");
        builder.comment(new String[]{"Fill amount of oxygen to helmet when player in water or rain", "in rain, produce efficiency is half"});
        this.moduleSpaceBreathing_maxProduceRate = builder.define("maxProduceRate", (Object)4);
        builder.comment("Oxygen gas usage when provide Beyond Earth oxygen to player in space");
        this.moduleSpaceBreathing_oxygenUsing = builder.define("oxygenUsing", (Object)1);
        builder.comment("Duration of provided oxygen (oxygen provide interval)");
        this.moduleSpaceBreathing_oxygenDuration = builder.define("oxygenDuration", (Object)4);
        builder.comment("Energy usage when provide Beyond Earth oxygen to player in space");
        this.moduleSpaceBreathing_energyUsing = builder.define("energyUsing", (Object)10);
        builder.pop();
        builder.push("module_space_fire_proof_unit");
        builder.comment("Energy usage when prevent fire every tick in Beyond Earth hot planets (e.g. Venus, Mercury)");
        this.moduleSpaceFireProof_energyUsing = builder.define("energyUsing", (Object)10);
        builder.pop();
        builder.push("module_venus_acid_proof_unit");
        builder.comment("Energy usage when prevent acid rain damage every tick in Beyond Earth venus");
        this.moduleVenusAcidProof_energyUsing = builder.define("energyUsing", (Object)10);
        builder.pop();
        builder.push("module_space_gravity_normalizing_unit");
        builder.comment("Energy usage when normalizing gravity every tick in Beyond Earth dimensions");
        this.moduleSpaceGravityNormalizing_energyUsing = builder.define("energyUsing", (Object)10);
        builder.pop();
        builder.push("module_gravitational_modulating_unit");
        builder.comment("Can normalize gravity instead module_space_gravity_normalizing_unit");
        this.moduleGravitationalModulating_normalizable = builder.define("normalizable", true);
        builder.comment("Energy usage when normalizing gravity every tick in Beyond Earth dimensions");
        this.moduleGravitationalModulating_energyUsing = builder.define("energyUsing", (Object)10);
        builder.pop();
    }
}

