/*
 * Decompiled with CFR 0.152.
 */
package beyond_earth_giselle_addon.common.content.fuel;

import beyond_earth_giselle_addon.common.entity.BeyondEarthRocketHelper;
import beyond_earth_giselle_addon.common.entity.BeyondEarthRoverHelper;
import beyond_earth_giselle_addon.common.event.EntityGaugeValueFetchEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.mrscauthd.beyond_earth.entity.RoverEntity;
import net.mrscauthd.beyond_earth.gauge.GaugeValueHelper;
import net.mrscauthd.beyond_earth.gauge.GaugeValueSimple;
import net.mrscauthd.beyond_earth.gauge.IGaugeValue;

public class EventListenerFuelGauge {
    @SubscribeEvent
    public static void onEntityGaugeValueFetch(EntityGaugeValueFetchEvent e) {
        Entity entity = e.getEntity();
        if (entity instanceof RoverEntity) {
            int amount = BeyondEarthRoverHelper.getFuelAmount(entity);
            int capacity = BeyondEarthRoverHelper.getFuelCapacity(entity);
            e.getValues().add(GaugeValueHelper.getFuel((int)amount, (int)capacity));
        } else if (BeyondEarthRocketHelper.isBeyondEarthRocket(entity)) {
            int amount = BeyondEarthRocketHelper.getFuelAmount(entity);
            int capacity = BeyondEarthRocketHelper.getFuelCapacity(entity);
            e.getValues().add((IGaugeValue)new GaugeValueSimple(GaugeValueHelper.FUEL_NAME, (int)((double)amount / ((double)capacity / 100.0)), 100, (Component)null, "%").color(-1600546499));
        }
    }
}

