/*
 * Decompiled with CFR 0.152.
 */
package beyond_earth_giselle_addon.common.content.proof;

import beyond_earth_giselle_addon.common.content.proof.LivingProofEvent;
import beyond_earth_giselle_addon.common.content.proof.SpaceFireProofUtils;
import beyond_earth_giselle_addon.common.content.proof.SpaceGravityProofUtils;
import beyond_earth_giselle_addon.common.content.proof.SpaceOxygenProofUtils;
import beyond_earth_giselle_addon.common.content.proof.VenusAcidProofUtils;
import beyond_earth_giselle_addon.common.util.NBTUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public abstract class ProofAbstractUtils {
    public static final String NBT_PROOF_DURATION_KEY = "proof_duration";

    public static void register(IEventBus bus) {
        bus.register((Object)SpaceOxygenProofUtils.INSTANCE);
        bus.register((Object)SpaceGravityProofUtils.INSTANCE);
        bus.register((Object)SpaceFireProofUtils.INSTANCE);
        bus.register((Object)VenusAcidProofUtils.INSTANCE);
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent e) {
        LivingEntity entity = e.getEntityLiving();
        this.reduceProofDuration(entity);
    }

    public void reduceProofDuration(LivingEntity entity) {
        int proofDuration = this.getProofDuration(entity);
        if (proofDuration > 0) {
            this.setProofDuration(entity, proofDuration - 1);
        }
    }

    public int getProofDuration(LivingEntity entity) {
        CompoundTag compound = NBTUtils.getTag((Entity)entity, this.getNBTKey());
        return compound != null ? compound.m_128451_(NBT_PROOF_DURATION_KEY) : 0;
    }

    public void setProofDuration(LivingEntity entity, int proofDuration) {
        CompoundTag compound = NBTUtils.getOrCreateTag((Entity)entity, this.getNBTKey());
        compound.m_128356_(NBT_PROOF_DURATION_KEY, (long)Math.max(proofDuration, 0));
    }

    public boolean tryProvideProof(LivingEvent e) {
        LivingEntity entity = e.getEntityLiving();
        if (e.isCanceled()) {
            return false;
        }
        return this.tryProvideProof(entity);
    }

    public boolean tryProvideProof(LivingEntity entity) {
        if (this.getProofDuration(entity) > 0) {
            return true;
        }
        LivingProofEvent event = this.createEvent(entity);
        if (event != null) {
            LivingProofEvent.postUntilDuration(event);
            int proofDuration = event.getProofDuration();
            if (proofDuration > 0) {
                this.setProofDuration(entity, proofDuration);
                return true;
            }
        }
        return false;
    }

    public abstract LivingProofEvent createEvent(LivingEntity var1);

    public abstract String getNBTKey();
}

