/*
 * Decompiled with CFR 0.152.
 */
package beyond_earth_giselle_addon.common.content.proof;

import beyond_earth_giselle_addon.common.content.proof.ProofSession;
import beyond_earth_giselle_addon.common.enchantment.EnchantmentEnergyStorage;
import beyond_earth_giselle_addon.common.enchantment.EnchantmentHelper2;
import beyond_earth_giselle_addon.common.util.LivingEntityHelper;
import com.mojang.datafixers.util.Pair;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public abstract class ProofEnchantmentSession
extends ProofSession {
    private EnchantmentEnergyStorage enchantment;
    private ItemStack enchantedItem;
    private IEnergyStorage energyStorage;
    private int enchantLevel;

    public ProofEnchantmentSession(LivingEntity entity, EnchantmentEnergyStorage enchantment) {
        super(entity);
        this.enchantment = enchantment;
        Pair<ItemStack, Integer> pair = EnchantmentHelper2.getEnchantmentItemAndLevel(enchantment, entity);
        this.enchantedItem = (ItemStack)pair.getFirst();
        this.energyStorage = (IEnergyStorage)this.enchantedItem.getCapability(CapabilityEnergy.ENERGY).orElse(null);
        this.enchantLevel = (Integer)pair.getSecond();
    }

    @Override
    public boolean canProvide() {
        int energyUsing;
        ItemStack enchantedItem = this.getEnchantedItem();
        IEnergyStorage energyStorage = this.getEnergyStorage();
        int enchantLevel = this.getEnchantLevel();
        if (enchantedItem.m_41619_() || enchantLevel == 0 || energyStorage == null) {
            return false;
        }
        LivingEntity entity = this.getEntity();
        if (LivingEntityHelper.isPlayingMode(entity) && energyStorage.extractEnergy(energyUsing = this.getEnergyUsing(), true) < energyUsing) {
            return false;
        }
        return super.canProvide();
    }

    @Override
    public void onProvide() {
        super.onProvide();
        LivingEntity entity = this.getEntity();
        if (LivingEntityHelper.isPlayingMode(entity) && !entity.m_183503_().m_5776_()) {
            int energyUsing = this.getEnergyUsing();
            this.getEnergyStorage().extractEnergy(energyUsing, false);
        }
    }

    public EnchantmentEnergyStorage getEnchantment() {
        return this.enchantment;
    }

    public ItemStack getEnchantedItem() {
        return this.enchantedItem;
    }

    public IEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public int getEnchantLevel() {
        return this.enchantLevel;
    }

    public abstract int getEnergyUsing();
}

