/*
 * Decompiled with CFR 0.152.
 */
package beyond_earth_giselle_addon.common.content.proof;

import beyond_earth_giselle_addon.common.capability.IOxygenCharger;
import beyond_earth_giselle_addon.common.capability.OxygenChargerUtils;
import beyond_earth_giselle_addon.common.config.AddonConfigs;
import beyond_earth_giselle_addon.common.content.proof.ProofEnchantmentSession;
import beyond_earth_giselle_addon.common.enchantment.EnchantmentEnergyStorage;
import beyond_earth_giselle_addon.common.util.LivingEntityHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.mrscauthd.beyond_earth.capability.oxygen.IOxygenStorage;

public class SpaceOxygenProofEnchantmentSession
extends ProofEnchantmentSession {
    private IOxygenStorage oxygenStorage;

    public SpaceOxygenProofEnchantmentSession(LivingEntity entity, EnchantmentEnergyStorage enchantment) {
        super(entity, enchantment);
        ItemStack enchantedItem;
        int oxygenUsing;
        IOxygenCharger oxygenCharger;
        this.oxygenStorage = LivingEntityHelper.isPlayingMode(entity) ? ((oxygenCharger = OxygenChargerUtils.firstExtractableOxygenCharger(entity, oxygenUsing = this.getOxygenUsing(), enchantedItem = this.getEnchantedItem())) != null ? oxygenCharger.getOxygenStorage() : null) : null;
    }

    @Override
    public boolean canProvide() {
        LivingEntity entity = this.getEntity();
        if (LivingEntityHelper.isPlayingMode(entity)) {
            IOxygenStorage oxygenStorage = this.getOxygenStorage();
            int oxygenUsing = this.getOxygenUsing();
            if (oxygenStorage == null || oxygenStorage.extractOxygen(oxygenUsing, true) < oxygenUsing) {
                return false;
            }
        }
        return super.canProvide();
    }

    @Override
    public void onProvide() {
        IOxygenStorage oxygenStorage;
        super.onProvide();
        LivingEntity entity = this.getEntity();
        if (LivingEntityHelper.isPlayingMode(entity) && (oxygenStorage = this.getOxygenStorage()) != null && !entity.m_183503_().m_5776_()) {
            int oxygenUsing = this.getOxygenUsing();
            oxygenStorage.extractOxygen(oxygenUsing, false);
        }
    }

    @Override
    public int getEnergyUsing() {
        return (Integer)AddonConfigs.Common.enchantments.space_breathing_energyUsing.get();
    }

    @Override
    public int getProofDuration() {
        return (Integer)AddonConfigs.Common.enchantments.space_breathing_oxygenDuration.get();
    }

    public IOxygenStorage getOxygenStorage() {
        return this.oxygenStorage;
    }

    public int getOxygenUsing() {
        return 1;
    }
}

