/*
 * Decompiled with CFR 0.152.
 */
package beyond_earth_giselle_addon.common.enchantment;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class EnchantmentHelper2 {
    private static final Map<Enchantment, String> DESCRIPTION_KEYS = new HashMap<Enchantment, String>();
    private static final Map<Enchantment, Component> DESCRIPTION_TEXTS = new HashMap<Enchantment, Component>();
    private static final List<String> DESCRIPTION_SUFFIXES = Lists.newArrayList((Object[])new String[]{"desc", "description"});

    public static List<String> getDescriptionSuffixes() {
        return Collections.unmodifiableList(DESCRIPTION_SUFFIXES);
    }

    public static boolean addDescriptionSuffix(String suffix) {
        return DESCRIPTION_SUFFIXES.add(suffix);
    }

    public static String getDescriptionKey(Enchantment enchantment) {
        return DESCRIPTION_KEYS.computeIfAbsent(enchantment, e -> {
            String descriptionId = e.m_44704_();
            for (String suffix : DESCRIPTION_SUFFIXES) {
                String key = descriptionId + "." + suffix;
                if (!I18n.m_118936_((String)key)) continue;
                return key;
            }
            return descriptionId + DESCRIPTION_SUFFIXES.get(0);
        });
    }

    public static Component getDescriptionText(Enchantment enchantment) {
        return DESCRIPTION_TEXTS.computeIfAbsent(enchantment, e -> new TranslatableComponent(EnchantmentHelper2.getDescriptionKey(enchantment)).m_130940_(ChatFormatting.GOLD));
    }

    @Nonnull
    public static Pair<ItemStack, Integer> getEnchantmentItemAndLevel(Enchantment enchantment, LivingEntity entity) {
        Collection iterable = enchantment.m_44684_(entity).values();
        ItemStack stack = ItemStack.f_41583_;
        int level = 0;
        if (iterable != null) {
            for (ItemStack itemstack : iterable) {
                int i = EnchantmentHelper.m_44843_((Enchantment)enchantment, (ItemStack)itemstack);
                if (i <= level) continue;
                stack = itemstack;
                level = i;
            }
        }
        return Pair.of((Object)stack, (Object)level);
    }

    private EnchantmentHelper2() {
    }
}

