/*
 * Decompiled with CFR 0.152.
 */
package beyond_earth_giselle_addon.common.enchantment;

import beyond_earth_giselle_addon.common.config.AddonConfigs;
import beyond_earth_giselle_addon.common.config.EnchantmentsConfig;
import beyond_earth_giselle_addon.common.enchantment.EnchantmentHelper2;
import beyond_earth_giselle_addon.common.registries.AddonEnchantments;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;

public class EventListenerEnchantmentTooltip {
    private static final Set<String> DESCRIPTION_MODS = Sets.newHashSet((Object[])new String[]{"enchdesc", "cofh_core"});
    private static boolean tooltipEnabeldCached = false;
    private static boolean tooltipEnabled = false;

    public static boolean tooltipEnabled() {
        if (tooltipEnabeldCached) {
            return tooltipEnabled;
        }
        EnchantmentsConfig config = AddonConfigs.Common.enchantments;
        tooltipEnabled = (Boolean)config.tooltip_Enabled.get() != false && ((Boolean)config.tooltip_Ignore.get() != false || !EventListenerEnchantmentTooltip.isDescriptionModsLoaded());
        return tooltipEnabled;
    }

    public static void addDescriptionMod(String modid) {
        if (DESCRIPTION_MODS.add(modid)) {
            tooltipEnabled = EventListenerEnchantmentTooltip.tooltipEnabled() && !ModList.get().isLoaded(modid);
        }
    }

    public static boolean isDescriptionModsLoaded() {
        for (String mod : DESCRIPTION_MODS) {
            if (!ModList.get().isLoaded(mod)) continue;
            return true;
        }
        return false;
    }

    public static Set<String> getDescriptionMods() {
        return Collections.unmodifiableSet(DESCRIPTION_MODS);
    }

    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent e) {
        ItemStack itemstack = e.getItemStack();
        if (itemstack.m_41720_() instanceof EnchantedBookItem) {
            if (!EventListenerEnchantmentTooltip.tooltipEnabled()) {
                return;
            }
            List lines = e.getToolTip();
            block0: for (Enchantment enchantment : AddonEnchantments.ENCHANTMENTS.getObjects()) {
                for (Component line : lines) {
                    TranslatableComponent tline;
                    if (!(line instanceof TranslatableComponent) || !(tline = (TranslatableComponent)line).m_131328_().equals(enchantment.m_44704_())) continue;
                    lines.add(lines.indexOf(line) + 1, EnchantmentHelper2.getDescriptionText(enchantment));
                    continue block0;
                }
            }
        }
    }
}

