/*
 * Decompiled with CFR 0.152.
 */
package beyond_earth_giselle_addon.common.entity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.registries.RegistryObject;
import net.mrscauthd.beyond_earth.ModInit;
import net.mrscauthd.beyond_earth.entity.RocketTier1Entity;
import net.mrscauthd.beyond_earth.entity.RocketTier2Entity;
import net.mrscauthd.beyond_earth.entity.RocketTier3Entity;
import net.mrscauthd.beyond_earth.entity.RocketTier4Entity;

public class BeyondEarthRocketHelper {
    private static final List<RegistryObject<? extends EntityType<?>>> types = new ArrayList();

    public static boolean isBeyondEarthRocket(Entity entity) {
        if (entity instanceof RocketTier1Entity) {
            return true;
        }
        if (entity instanceof RocketTier2Entity) {
            return true;
        }
        if (entity instanceof RocketTier3Entity) {
            return true;
        }
        return entity instanceof RocketTier4Entity;
    }

    public static EntityType<?>[] getBeyondEarthRocketTypes() {
        return (EntityType[])types.stream().map(RegistryObject::get).toArray(EntityType[]::new);
    }

    public static boolean isBeyondEarthRocket(EntityType<?> type) {
        for (EntityType<?> entityType : BeyondEarthRocketHelper.getBeyondEarthRocketTypes()) {
            if (entityType != type) continue;
            return true;
        }
        return false;
    }

    public static int getBucketsAmount(Entity entity) {
        SynchedEntityData entityData = entity.m_20088_();
        if (entity instanceof RocketTier1Entity) {
            return (Boolean)entityData.m_135370_(RocketTier1Entity.BUCKET) != false ? 1 : 0;
        }
        if (entity instanceof RocketTier2Entity) {
            return (Integer)entityData.m_135370_(RocketTier2Entity.BUCKETS);
        }
        if (entity instanceof RocketTier3Entity) {
            return (Integer)entityData.m_135370_(RocketTier3Entity.BUCKETS);
        }
        if (entity instanceof RocketTier4Entity) {
            return (Integer)entityData.m_135370_(RocketTier4Entity.BUCKETS);
        }
        return 0;
    }

    public static void setBucketsAmount(Entity entity, int buckets) {
        buckets = Mth.m_14045_((int)buckets, (int)0, (int)BeyondEarthRocketHelper.getBucketsCapacity(entity));
        SynchedEntityData entityData = entity.m_20088_();
        if (entity instanceof RocketTier1Entity) {
            entityData.m_135381_(RocketTier1Entity.BUCKET, (Object)(buckets > 0 ? 1 : 0));
        } else if (entity instanceof RocketTier2Entity) {
            entityData.m_135381_(RocketTier2Entity.BUCKETS, (Object)buckets);
        } else if (entity instanceof RocketTier3Entity) {
            entityData.m_135381_(RocketTier3Entity.BUCKETS, (Object)buckets);
        } else if (entity instanceof RocketTier4Entity) {
            entityData.m_135381_(RocketTier4Entity.BUCKETS, (Object)buckets);
        }
    }

    public static int getBucketsCapacity(Entity entity) {
        if (entity instanceof RocketTier1Entity) {
            return 1;
        }
        if (entity instanceof RocketTier2Entity) {
            return 3;
        }
        if (entity instanceof RocketTier3Entity) {
            return 3;
        }
        if (entity instanceof RocketTier4Entity) {
            return 3;
        }
        return 0;
    }

    public static int getFuelAmount(Entity entity) {
        SynchedEntityData entityData = entity.m_20088_();
        if (entity instanceof RocketTier1Entity) {
            return (Integer)entityData.m_135370_(RocketTier1Entity.FUEL);
        }
        if (entity instanceof RocketTier2Entity) {
            return (Integer)entityData.m_135370_(RocketTier2Entity.FUEL);
        }
        if (entity instanceof RocketTier3Entity) {
            return (Integer)entityData.m_135370_(RocketTier3Entity.FUEL);
        }
        if (entity instanceof RocketTier4Entity) {
            return (Integer)entityData.m_135370_(RocketTier4Entity.FUEL);
        }
        return 0;
    }

    public static void setCurrentFuel(Entity entity, int fuel) {
        fuel = Mth.m_14045_((int)fuel, (int)0, (int)BeyondEarthRocketHelper.getFuelCapacity(entity));
        SynchedEntityData entityData = entity.m_20088_();
        if (entity instanceof RocketTier1Entity) {
            entityData.m_135381_(RocketTier1Entity.FUEL, (Object)fuel);
        } else if (entity instanceof RocketTier2Entity) {
            entityData.m_135381_(RocketTier2Entity.FUEL, (Object)fuel);
        } else if (entity instanceof RocketTier3Entity) {
            entityData.m_135381_(RocketTier3Entity.FUEL, (Object)fuel);
        } else if (entity instanceof RocketTier4Entity) {
            entityData.m_135381_(RocketTier4Entity.FUEL, (Object)fuel);
        }
    }

    public static int getFuelCapacity(Entity entity) {
        return 300;
    }

    private BeyondEarthRocketHelper() {
    }

    static {
        types.add(ModInit.TIER_1_ROCKET);
        types.add(ModInit.TIER_2_ROCKET);
        types.add(ModInit.TIER_3_ROCKET);
        types.add(ModInit.TIER_4_ROCKET);
    }
}

