/*
 * Decompiled with CFR 0.152.
 */
package beyond_earth_giselle_addon.common.item;

import beyond_earth_giselle_addon.common.capability.ChargeMode;
import beyond_earth_giselle_addon.common.capability.IChargeMode;
import beyond_earth_giselle_addon.common.capability.IOxygenCharger;
import beyond_earth_giselle_addon.common.capability.OxygenCanCapabilityProvider;
import beyond_earth_giselle_addon.common.capability.OxygenChargerUtils;
import beyond_earth_giselle_addon.common.config.AddonConfigs;
import beyond_earth_giselle_addon.common.config.ItemsConfig;
import beyond_earth_giselle_addon.common.util.TranslationUtils;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.mrscauthd.beyond_earth.capability.oxygen.IOxygenStorage;
import net.mrscauthd.beyond_earth.capability.oxygen.OxygenUtil;
import net.mrscauthd.beyond_earth.gauge.GaugeTextHelper;

public class OxygenCanItem
extends Item {
    public OxygenCanItem(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> list) {
        ItemStack full;
        IOxygenCharger oxygenCharger;
        super.m_6787_(group, list);
        if (this.m_41389_(group) && (oxygenCharger = this.initCapabilities(full = new ItemStack((ItemLike)this), null).getOxygenCharger()) != null) {
            oxygenCharger.setChargeMode(ChargeMode.ALL);
            IOxygenStorage oxygenStorage = oxygenCharger.getOxygenStorage();
            oxygenStorage.setOxygenStored(oxygenStorage.getMaxOxygenStored());
            list.add((Object)full);
        }
    }

    public Rarity m_41460_(ItemStack stack) {
        return this.m_5812_(stack) ? Rarity.EPIC : super.m_41460_(stack);
    }

    public boolean m_5812_(ItemStack stack) {
        IOxygenCharger oxygenCharger = OxygenChargerUtils.getOxygenCharger(stack);
        if (oxygenCharger != null && oxygenCharger.getOxygenStorage().extractOxygen(1, true) > 0 && oxygenCharger.getChargeMode() != ChargeMode.NONE) {
            return true;
        }
        return super.m_5812_(stack);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (level.m_5776_()) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        IOxygenCharger oxygenCharger = OxygenChargerUtils.getOxygenCharger(stack);
        if (oxygenCharger != null && !player.m_6144_()) {
            IChargeMode chargeMode = oxygenCharger.getChargeMode();
            List<IChargeMode> modes = oxygenCharger.getAvailableChargeModes();
            int nextIndex = (modes.indexOf(chargeMode) + 1) % modes.size();
            IChargeMode nextMode = modes.get(nextIndex);
            oxygenCharger.setChargeMode(nextMode);
            player.m_6352_(TranslationUtils.descriptionChargeMode(nextMode), player.m_142081_());
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, level, entity, slot, selected);
        if (!level.m_5776_()) {
            OxygenCanItem.transferToItems(entity, stack);
        }
    }

    public static void transferToItems(Entity entity, ItemStack stack) {
        if (entity == null || stack == null) {
            return;
        }
        IOxygenCharger oxygenCharger = OxygenChargerUtils.getOxygenCharger(stack);
        if (oxygenCharger == null) {
            return;
        }
        IOxygenStorage oxygenStorage = oxygenCharger.getOxygenStorage();
        Iterable<ItemStack> itemStacks = oxygenCharger.getChargeMode().getItemStacks(entity);
        int transfer = (Integer)AddonConfigs.Common.items.oxygenCan_OxygenTransfer.get();
        if (transfer <= 0) {
            return;
        }
        for (ItemStack itemStack : itemStacks) {
            int extracting;
            int receiving;
            IOxygenStorage targetOxygenStorage;
            if (OxygenChargerUtils.getOxygenCharger(itemStack) != null || (targetOxygenStorage = OxygenUtil.getItemStackOxygenStorage((ItemStack)itemStack)) == null || (receiving = targetOxygenStorage.receiveOxygen(extracting = oxygenStorage.extractOxygen(transfer, true), true)) <= 0) continue;
            oxygenStorage.extractOxygen(receiving, false);
            targetOxygenStorage.receiveOxygen(receiving, false);
            if ((transfer -= receiving) > 0) continue;
            break;
        }
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        IOxygenCharger oxygenCharger = OxygenChargerUtils.getOxygenCharger(stack);
        if (oxygenCharger != null) {
            tooltip.add(TranslationUtils.descriptionChargeMode(oxygenCharger.getChargeMode()));
            tooltip.add((Component)GaugeTextHelper.buildSpacesuitOxygenTooltip((IOxygenStorage)oxygenCharger.getOxygenStorage()));
        }
    }

    public boolean m_142522_(ItemStack stack) {
        return OxygenChargerUtils.getOxygenCharger(stack) != null;
    }

    public int m_142158_(ItemStack stack) {
        IOxygenCharger oxygenCharger = OxygenChargerUtils.getOxygenCharger(stack);
        double ratio = oxygenCharger != null ? oxygenCharger.getOxygenStorage().getOxygenStoredRatio() : 0.0;
        return (int)(ratio * 13.0);
    }

    public int m_142159_(ItemStack stack) {
        IOxygenCharger oxygenCharger = OxygenChargerUtils.getOxygenCharger(stack);
        double ratio = oxygenCharger != null ? oxygenCharger.getOxygenStorage().getOxygenStoredRatio() : 0.0;
        return Mth.m_14169_((float)((float)(ratio / 3.0)), (float)1.0f, (float)1.0f);
    }

    public OxygenCanCapabilityProvider initCapabilities(ItemStack stack, CompoundTag tag) {
        ItemsConfig config = AddonConfigs.Common.items;
        int capacity = (Integer)config.oxygenCan_OxygenCapacity.get();
        int transfer = (Integer)config.oxygenCan_OxygenTransfer.get();
        return new OxygenCanCapabilityProvider(stack, capacity, transfer);
    }
}

