/*
 * Decompiled with CFR 0.152.
 */
package beyond_earth_giselle_addon.common.network;

import beyond_earth_giselle_addon.common.BeyondEarthAddon;
import beyond_earth_giselle_addon.common.network.AbstractMessage;
import beyond_earth_giselle_addon.common.network.AdvancedCompressorMessageMode;
import beyond_earth_giselle_addon.common.network.FlagEditMessageOpen;
import beyond_earth_giselle_addon.common.network.FlagEditMessageSave;
import beyond_earth_giselle_addon.common.network.FuelLoaderMessageWorkingAreaVisible;
import beyond_earth_giselle_addon.common.network.GravityNormalizerMessageRange;
import beyond_earth_giselle_addon.common.network.GravityNormalizerMessageWorkingAreaVisible;
import beyond_earth_giselle_addon.common.network.IS2ISMachineMessageAutoEject;
import beyond_earth_giselle_addon.common.network.IS2ISMachineMessageAutoPull;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class AddonNetwork {
    public static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)BeyondEarthAddon.rl("main"), () -> "1", "1"::equals, "1"::equals);
    private static int messageID;

    public static void registerAll() {
        AddonNetwork.registerMessage(IS2ISMachineMessageAutoPull.class, IS2ISMachineMessageAutoPull::new);
        AddonNetwork.registerMessage(IS2ISMachineMessageAutoEject.class, IS2ISMachineMessageAutoEject::new);
        AddonNetwork.registerMessage(FuelLoaderMessageWorkingAreaVisible.class, FuelLoaderMessageWorkingAreaVisible::new);
        AddonNetwork.registerMessage(GravityNormalizerMessageWorkingAreaVisible.class, GravityNormalizerMessageWorkingAreaVisible::new);
        AddonNetwork.registerMessage(GravityNormalizerMessageRange.class, GravityNormalizerMessageRange::new);
        AddonNetwork.registerMessage(AdvancedCompressorMessageMode.class, AdvancedCompressorMessageMode::new);
        AddonNetwork.registerMessage(FlagEditMessageOpen.class, FlagEditMessageOpen::new);
        AddonNetwork.registerMessage(FlagEditMessageSave.class, FlagEditMessageSave::new);
    }

    public static <T extends AbstractMessage> void registerMessage(Class<T> messageType, Supplier<T> supplier) {
        AddonNetwork.registerMessage(messageType, AbstractMessage::encode, buffer -> {
            AbstractMessage msg = (AbstractMessage)supplier.get();
            msg.decode((FriendlyByteBuf)buffer);
            return msg;
        }, (msg, s) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)s.get();
            msg.onHandle(context);
            context.setPacketHandled(true);
        });
    }

    public static <T> void registerMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        CHANNEL.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }

    public static void sendToServer(AbstractMessage message) {
        PacketDistributor.PacketTarget target = PacketDistributor.SERVER.noArg();
        CHANNEL.send(target, (Object)message);
    }

    public static void sendToServer(AbstractMessage ... messages) {
        for (AbstractMessage message : messages) {
            AddonNetwork.sendToServer(message);
        }
    }

    public static void sendToPlayer(ServerPlayer player, AbstractMessage message) {
        PacketDistributor.PacketTarget target = PacketDistributor.PLAYER.with(() -> player);
        CHANNEL.send(target, (Object)message);
    }

    public static void sendToPlayer(ServerPlayer player, AbstractMessage ... messages) {
        for (AbstractMessage message : messages) {
            AddonNetwork.sendToPlayer(player, message);
        }
    }

    public static void sendToPlayer(Collection<ServerPlayer> players, AbstractMessage message) {
        for (ServerPlayer player : players) {
            AddonNetwork.sendToPlayer(player, message);
        }
    }

    public static void sendToPlayer(Collection<ServerPlayer> players, AbstractMessage ... messages) {
        for (AbstractMessage message : messages) {
            AddonNetwork.sendToPlayer(players, message);
        }
    }

    private AddonNetwork() {
    }
}

