/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp;

import com.yogpc.qp.Config;
import com.yogpc.qp.Holder;
import com.yogpc.qp.QuarryPlusClient;
import com.yogpc.qp.data.QuarryPlusDataProvider;
import com.yogpc.qp.machines.workbench.EnableCondition;
import com.yogpc.qp.machines.workbench.EnchantmentIngredient;
import com.yogpc.qp.machines.workbench.QuarryDebugCondition;
import com.yogpc.qp.machines.workbench.WorkbenchRecipe;
import com.yogpc.qp.packet.PacketHandler;
import com.yogpc.qp.utils.ConfigCommand;
import java.lang.reflect.Field;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Logger;

@Mod(value="quarryplus")
public class QuarryPlus {
    public static final String Mod_Name = "QuarryPlus";
    public static final String modID = "quarryplus";
    public static final Logger LOGGER = QuarryPlus.getLogger("QuarryPlus");
    public static Config config;

    public QuarryPlus() {
        ForgeConfigSpec.Builder common = new ForgeConfigSpec.Builder();
        config = new Config(common);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)common.build());
        FMLJavaModLoadingContext.get().getModEventBus().register(Register.class);
        FMLJavaModLoadingContext.get().getModEventBus().register(QuarryPlusDataProvider.class);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> QuarryPlusClient::registerClientBus);
        MinecraftForge.EVENT_BUS.register(ConfigCommand.class);
    }

    public static Logger getLogger(Class<?> clazz) {
        return QuarryPlus.getLogger(clazz.getName());
    }

    public static Logger getLogger(String name) {
        try {
            Field field = Class.forName("net.minecraftforge.fml.ModLoader").getDeclaredField("LOGGER");
            field.setAccessible(true);
            org.apache.logging.log4j.core.Logger loaderLogger = (org.apache.logging.log4j.core.Logger)field.get(null);
            return loaderLogger.getContext().getLogger(name);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Can't access to LOGGER in loader.", e);
        }
    }

    public static class Register {
        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            Holder.blocks().forEach(arg_0 -> ((IForgeRegistry)event.getRegistry()).register(arg_0));
            event.getRegistry().register((IForgeRegistryEntry)Holder.BLOCK_DUMMY);
            event.getRegistry().register((IForgeRegistryEntry)Holder.BLOCK_DUMMY_REPLACER);
        }

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            Holder.items().forEach(arg_0 -> ((IForgeRegistry)event.getRegistry()).register(arg_0));
            event.getRegistry().register((IForgeRegistryEntry)Holder.BLOCK_DUMMY.blockItem);
            event.getRegistry().register((IForgeRegistryEntry)Holder.BLOCK_DUMMY_REPLACER.blockItem);
        }

        @SubscribeEvent
        public static void registerTiles(RegistryEvent.Register<BlockEntityType<?>> event) {
            Holder.entityTypes().forEach(arg_0 -> ((IForgeRegistry)event.getRegistry()).register(arg_0));
        }

        @SubscribeEvent
        public static void registerContainers(RegistryEvent.Register<MenuType<?>> event) {
            Holder.menuTypes().forEach(arg_0 -> ((IForgeRegistry)event.getRegistry()).register(arg_0));
        }

        @SubscribeEvent
        public static void registerRecipe(RegistryEvent.Register<RecipeSerializer<?>> event) {
            event.getRegistry().register((IForgeRegistryEntry)WorkbenchRecipe.SERIALIZER);
            CraftingHelper.register((ResourceLocation)new ResourceLocation(QuarryPlus.modID, "enchantment_ingredient"), (IIngredientSerializer)EnchantmentIngredient.Serializer.INSTANCE);
            CraftingHelper.register((IConditionSerializer)new EnableCondition.Serializer());
            CraftingHelper.register((IConditionSerializer)new QuarryDebugCondition.Serializer());
        }

        @SubscribeEvent
        public static void setup(FMLCommonSetupEvent event) {
            PacketHandler.init();
        }
    }
}

