/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.data;

import com.google.gson.JsonElement;
import com.yogpc.qp.data.QuarryPlusDataProvider;
import com.yogpc.qp.machines.EnchantedLootFunction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

class LootTableSerializeHelper
extends BlockLoot
implements QuarryPlusDataProvider.DataBuilder {
    private final Block block;
    private final List<LootItemFunction.Builder> functions;

    LootTableSerializeHelper(Block block, List<LootItemFunction.Builder> functions) {
        this.block = block;
        this.functions = functions;
    }

    @Override
    public ResourceLocation location() {
        return this.block.getRegistryName();
    }

    @Override
    public JsonElement build() {
        LootPoolSingletonContainer.Builder value = LootItem.m_79579_((ItemLike)this.block);
        this.functions.forEach(arg_0 -> ((LootPoolSingletonContainer.Builder)value).m_5577_(arg_0));
        LootTable.Builder builder = LootTable.m_79147_().m_79161_((LootPool.Builder)BlockLoot.m_124134_((ItemLike)this.block, (ConditionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)value)));
        builder.m_79165_(LootContextParamSets.f_81421_);
        return LootTables.m_79200_((LootTable)builder.m_79167_());
    }

    LootTableSerializeHelper add(LootItemFunction.Builder builder) {
        ArrayList<LootItemFunction.Builder> copy = new ArrayList<LootItemFunction.Builder>(this.functions);
        copy.add(builder);
        return new LootTableSerializeHelper(this.block, copy);
    }

    static LootTableSerializeHelper withDrop(Block block) {
        return new LootTableSerializeHelper(block, Collections.emptyList());
    }

    static LootTableSerializeHelper withEnchantedDrop(Block block) {
        return new LootTableSerializeHelper(block, Collections.singletonList(EnchantedLootFunction.builder()));
    }
}

