/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.yogpc.qp.data.BlockDrop;
import com.yogpc.qp.data.Recipe;
import com.yogpc.qp.data.RecipeAdvancement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;

public class QuarryPlusDataProvider {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        if (event.includeServer()) {
            event.getGenerator().m_123914_((DataProvider)new BlockDrop(event.getGenerator()));
            event.getGenerator().m_123914_((DataProvider)new Recipe(event.getGenerator()));
            event.getGenerator().m_123914_((DataProvider)new RecipeAdvancement(event.getGenerator()));
        }
    }

    static ResourceLocation location(String path) {
        return new ResourceLocation("quarryplus", path);
    }

    static abstract class QuarryDataProvider
    implements DataProvider {
        protected final DataGenerator generatorIn;

        protected QuarryDataProvider(DataGenerator generatorIn) {
            this.generatorIn = generatorIn;
        }

        public void m_6865_(HashCache cache) throws IOException {
            Path path = this.generatorIn.m_123916_();
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            for (DataBuilder dataBuilder : this.data()) {
                Path out = path.resolve("data/%s/%s/%s.json".formatted(dataBuilder.location().m_135827_(), this.directory(), dataBuilder.location().m_135815_()));
                DataProvider.m_123920_((Gson)gson, (HashCache)cache, (JsonElement)dataBuilder.build(), (Path)out);
            }
        }

        public String m_6055_() {
            return this.getClass().getName();
        }

        abstract String directory();

        abstract List<? extends DataBuilder> data();
    }

    static interface DataBuilder {
        public ResourceLocation location();

        public JsonElement build();
    }
}

