/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.data;

import com.google.gson.JsonObject;
import com.yogpc.qp.Holder;
import com.yogpc.qp.data.QuarryPlusDataProvider;
import com.yogpc.qp.data.RecipeSerializeHelper;
import com.yogpc.qp.machines.workbench.EnableCondition;
import com.yogpc.qp.machines.workbench.EnchantmentIngredient;
import com.yogpc.qp.machines.workbench.IngredientList;
import com.yogpc.qp.machines.workbench.IngredientRecipe;
import com.yogpc.qp.machines.workbench.IngredientWithCount;
import com.yogpc.qp.machines.workbench.QuarryDebugCondition;
import com.yogpc.qp.machines.workbench.WorkbenchRecipe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class Recipe
extends QuarryPlusDataProvider.QuarryDataProvider {
    private static final String MODULE_RECIPE_GROUP = "quarryplus:group_module";

    Recipe(DataGenerator generatorIn) {
        super(generatorIn);
    }

    @Override
    String directory() {
        return "recipes";
    }

    @Override
    List<? extends QuarryPlusDataProvider.DataBuilder> data() {
        return Stream.of(this.workbenchRecipes(), this.crafting(), this.debug()).flatMap(Collection::stream).toList();
    }

    private List<RecipeSerializeHelper> workbenchRecipes() {
        ArrayList<RecipeSerializeHelper> list = new ArrayList<RecipeSerializeHelper>();
        list.add(RecipeSerializeHelper.by(new FinishedWorkbenchRecipe(new IngredientRecipe(QuarryPlusDataProvider.location("quarry"), new ItemStack((ItemLike)Holder.BLOCK_QUARRY), 320000000000000L, true, List.of(Recipe.makeList((Tag<Item>)Tags.Items.GEMS_DIAMOND, 32), Recipe.makeList((Tag<Item>)Tags.Items.INGOTS_GOLD, 32), Recipe.makeList((Tag<Item>)Tags.Items.INGOTS_IRON, 64), Recipe.makeList((Tag<Item>)Tags.Items.DUSTS_REDSTONE, 16), Recipe.makeList((Tag<Item>)Tags.Items.ENDER_PEARLS, 4))))).addCondition(new EnableCondition("quarry")));
        list.add(RecipeSerializeHelper.by(new FinishedWorkbenchRecipe(new IngredientRecipe(QuarryPlusDataProvider.location("pump_plus"), new ItemStack((ItemLike)Holder.BLOCK_PUMP), 320000000000000L, true, List.of(Recipe.makeList((Tag<Item>)Tags.Items.INGOTS_GOLD, 16), Recipe.makeList((Tag<Item>)Tags.Items.INGOTS_IRON, 48), Recipe.makeList((Tag<Item>)Tags.Items.DUSTS_REDSTONE, 64), Recipe.makeList((Tag<Item>)Tags.Items.GLASS_COLORLESS, 512), Recipe.makeList((ItemLike)Items.f_41982_, 80))))).addCondition(new EnableCondition("pump_plus")));
        list.add(RecipeSerializeHelper.by(new FinishedWorkbenchRecipe(new IngredientRecipe(QuarryPlusDataProvider.location("adv_pump"), new ItemStack((ItemLike)Holder.BLOCK_ADV_PUMP), 3200000000000000L, true, List.of(Recipe.as((Pair<Ingredient, Integer>)Pair.of((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Holder.BLOCK_PUMP}), (Object)2), Pair.of((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Holder.ITEM_PUMP_MODULE}), (Object)2)), Recipe.makeList((ItemLike)Holder.BLOCK_MINING_WELL, 2), Recipe.makeList((ItemLike)Holder.BLOCK_MARKER, 3))))).addCondition(new EnableCondition("adv_pump")));
        list.add(RecipeSerializeHelper.by(new FinishedWorkbenchRecipe(new IngredientRecipe(QuarryPlusDataProvider.location("marker"), new ItemStack((ItemLike)Holder.BLOCK_MARKER), 20000000000000L, true, List.of(Recipe.makeList((Tag<Item>)Tags.Items.INGOTS_GOLD, 7), Recipe.makeList((Tag<Item>)Tags.Items.INGOTS_IRON, 8), Recipe.makeList((Tag<Item>)Tags.Items.DUSTS_REDSTONE, 12), Recipe.makeList((Tag<Item>)Tags.Items.DUSTS_GLOWSTONE, 4), Recipe.makeList((ItemLike)Items.f_42534_, 12))))).addCondition(new EnableCondition("marker")));
        list.add(RecipeSerializeHelper.by(new FinishedWorkbenchRecipe(new IngredientRecipe(QuarryPlusDataProvider.location("mining_well"), new ItemStack((ItemLike)Holder.BLOCK_MINING_WELL), 160000000000000L, true, List.of(Recipe.makeList((Tag<Item>)Tags.Items.INGOTS_GOLD, 3), Recipe.makeList((Tag<Item>)Tags.Items.INGOTS_IRON, 16), Recipe.makeList((Tag<Item>)Tags.Items.DUSTS_REDSTONE, 8))))).addCondition(new EnableCondition("mining_well")));
        list.add(RecipeSerializeHelper.by(new FinishedWorkbenchRecipe(new IngredientRecipe(QuarryPlusDataProvider.location("status_checker"), new ItemStack((ItemLike)Holder.ITEM_CHECKER), 80000000000000L, true, List.of(Recipe.makeList((Tag<Item>)Tags.Items.INGOTS_GOLD, 16), Recipe.makeList((Tag<Item>)Tags.Items.INGOTS_IRON, 24), Recipe.makeList((Tag<Item>)Tags.Items.DUSTS_REDSTONE, 32), Recipe.makeList((Tag<Item>)Tags.Items.OBSIDIAN, 4), Recipe.makeList((ItemLike)Items.f_42534_, 8))))).addCondition(new EnableCondition("status_checker")));
        list.add(RecipeSerializeHelper.by(new FinishedWorkbenchRecipe(new IngredientRecipe(QuarryPlusDataProvider.location("y_setter"), new ItemStack((ItemLike)Holder.ITEM_Y_SETTER), 80000000000000L, true, List.of(Recipe.makeList((Tag<Item>)Tags.Items.INGOTS_GOLD, 32), Recipe.makeList((Tag<Item>)Tags.Items.GEMS_QUARTZ, 64), Recipe.makeList((ItemLike)Items.f_42350_, 16), Recipe.makeList((ItemLike)Items.f_42351_, 8))))).addCondition(new EnableCondition("y_setter")));
        list.add(RecipeSerializeHelper.by(new FinishedWorkbenchRecipe(new IngredientRecipe(QuarryPlusDataProvider.location("mover"), new ItemStack((ItemLike)Holder.BLOCK_MOVER), 320000000000000L, true, List.of(Recipe.makeList((Tag<Item>)Tags.Items.GEMS_DIAMOND, 32), Recipe.makeList((Tag<Item>)Tags.Items.INGOTS_GOLD, 8), Recipe.makeList((Tag<Item>)Tags.Items.INGOTS_IRON, 8), Recipe.makeList((Tag<Item>)Tags.Items.DUSTS_REDSTONE, 48), Recipe.makeList((Tag<Item>)Tags.Items.OBSIDIAN, 64), Recipe.makeList((ItemLike)Items.f_42146_, 2), Recipe.makeList((Tag<Item>)Tags.Items.ENDER_PEARLS, 2))))).addCondition(new EnableCondition("mover")));
        ItemStack diamond_pickaxe = new ItemStack((ItemLike)Items.f_42390_);
        diamond_pickaxe.m_41749_("Damage");
        list.add(RecipeSerializeHelper.by(new FinishedWorkbenchRecipe(new IngredientRecipe(QuarryPlusDataProvider.location("remove_bedrock_module"), new ItemStack((ItemLike)Holder.ITEM_BEDROCK_MODULE), 640000000000000L, true, List.of(Recipe.makeList((Tag<Item>)Tags.Items.OBSIDIAN, 32), Recipe.makeList((Tag<Item>)Tags.Items.STORAGE_BLOCKS_DIAMOND, 16), new IngredientList(new IngredientWithCount(new EnchantmentIngredient(diamond_pickaxe, List.of(new EnchantmentInstance(Enchantments.f_44985_, 1)), false), 1)))))).addCondition(new EnableCondition("remove_bedrock_module")));
        list.add(RecipeSerializeHelper.by(new FinishedWorkbenchRecipe(new IngredientRecipe(QuarryPlusDataProvider.location("fuel_module_normal"), new ItemStack((ItemLike)Holder.ITEM_FUEL_MODULE_NORMAL), 3200000000000L, true, List.of(Recipe.makeList((Tag<Item>)Tags.Items.INGOTS_GOLD, 16), Recipe.makeList((Tag<Item>)Tags.Items.RODS_BLAZE, 5), Recipe.makeList((Tag<Item>)Tags.Items.NETHERRACK, 64), Recipe.makeList((ItemLike)Items.f_41962_, 3))))).addCondition(new EnableCondition("fuel_module_normal")));
        ItemStack waterBottle = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_);
        list.add(RecipeSerializeHelper.by(new FinishedWorkbenchRecipe(new IngredientRecipe(QuarryPlusDataProvider.location("exp_pump"), new ItemStack((ItemLike)Holder.BLOCK_EXP_PUMP), 320000000000000L, true, List.of(Recipe.makeList((Tag<Item>)Tags.Items.INGOTS_GOLD, 16), Recipe.makeList((Tag<Item>)Tags.Items.INGOTS_IRON, 40), Recipe.makeList((Tag<Item>)Tags.Items.DUSTS_REDSTONE, 64), Recipe.as((Pair<Ingredient, Integer>)Pair.of((Object)IngredientWithCount.createNbtIngredient(waterBottle), (Object)128), Pair.of((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42612_}), (Object)1)), Recipe.makeList((ItemLike)Items.f_42129_, 32), Recipe.makeList((Tag<Item>)Tags.Items.ENDER_PEARLS, 2))))).addCondition(new EnableCondition("exp_pump")));
        list.add(RecipeSerializeHelper.by(new FinishedWorkbenchRecipe(new IngredientRecipe(QuarryPlusDataProvider.location("placer_plus"), new ItemStack((ItemLike)Holder.BLOCK_PLACER), 30000000000000L, true, List.of(Recipe.makeList((ItemLike)Items.f_41855_, 1), Recipe.makeList((Tag<Item>)Tags.Items.INGOTS_GOLD, 2), Recipe.makeList((Tag<Item>)Tags.Items.INGOTS_IRON, 1), Recipe.makeList((Tag<Item>)Tags.Items.DUSTS_REDSTONE, 1), Recipe.makeList((ItemLike)Items.f_41998_, 4))))).addCondition(new EnableCondition("placer_plus")));
        list.add(RecipeSerializeHelper.by(new FinishedWorkbenchRecipe(new IngredientRecipe(QuarryPlusDataProvider.location("replacer"), new ItemStack((ItemLike)Holder.BLOCK_REPLACER), 6400000000000000L, true, List.of(Recipe.makeList((ItemLike)Items.f_42447_, 32), Recipe.makeList((ItemLike)Items.f_42448_, 32), Recipe.makeList((Tag<Item>)Tags.Items.INGOTS_GOLD, 16), Recipe.makeList((Tag<Item>)Tags.Items.INGOTS_IRON, 32), Recipe.makeList((Tag<Item>)Tags.Items.DUSTS_REDSTONE, 16), Recipe.makeList((Tag<Item>)Tags.Items.ENDER_PEARLS, 4), Recipe.makeList((ItemLike)Items.f_42545_, 12), Recipe.makeList((ItemLike)Items.f_42683_, 1), Recipe.makeList((Tag<Item>)Tags.Items.NETHER_STARS, 2), Recipe.makeList((ItemLike)Items.f_41905_, 1024))))).addCondition(new EnableCondition("replacer")));
        list.add(RecipeSerializeHelper.by(new FinishedWorkbenchRecipe(new IngredientRecipe(QuarryPlusDataProvider.location("book_mover"), new ItemStack((ItemLike)Holder.BLOCK_BOOK_MOVER), 500000000000000L, true, List.of(Recipe.makeList((ItemLike)Holder.BLOCK_MOVER, 4), Recipe.makeList((ItemLike)Items.f_42065_, 2), Recipe.makeList((Tag<Item>)Tags.Items.BOOKSHELVES, 64), Recipe.makeList((Tag<Item>)Tags.Items.GEMS_DIAMOND, 16))))).addCondition(new EnableCondition("book_mover")));
        list.add(RecipeSerializeHelper.by(new FinishedWorkbenchRecipe(new IngredientRecipe(QuarryPlusDataProvider.location("adv_quarry"), new ItemStack((ItemLike)Holder.BLOCK_ADV_QUARRY), 3200000000000000L, true, List.of(Recipe.makeList((ItemLike)Holder.BLOCK_QUARRY, 3), Recipe.as((Pair<Ingredient, Integer>)Pair.of((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Holder.BLOCK_PUMP}), (Object)2), Pair.of((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Holder.ITEM_PUMP_MODULE}), (Object)2)), Recipe.makeList((ItemLike)Holder.BLOCK_MARKER, 3), Recipe.makeList((Tag<Item>)Tags.Items.STORAGE_BLOCKS_DIAMOND, 8), Recipe.makeList((Tag<Item>)Tags.Items.STORAGE_BLOCKS_EMERALD, 8), Recipe.makeList((ItemLike)Items.f_42545_, 64), Recipe.makeList((Tag<Item>)Tags.Items.NETHER_STARS, 2), Recipe.makeList((ItemLike)Items.f_42683_, 1))))).addCondition(new EnableCondition("adv_quarry")));
        list.add(RecipeSerializeHelper.by(new FinishedWorkbenchRecipe(new IngredientRecipe(QuarryPlusDataProvider.location("mini_quarry"), new ItemStack((ItemLike)Holder.BLOCK_MINI_QUARRY), 10000000000000L, true, List.of(Recipe.makeList((Tag<Item>)Tags.Items.GEMS_DIAMOND, 2), Recipe.makeList((Tag<Item>)Tags.Items.INGOTS_GOLD, 16), Recipe.makeList((Tag<Item>)Tags.Items.INGOTS_IRON, 32), Recipe.makeList((Tag<Item>)Tags.Items.DUSTS_REDSTONE, 8), Recipe.makeList((ItemLike)Items.f_42351_, 4))))).addCondition(new EnableCondition("mini_quarry")));
        list.add(RecipeSerializeHelper.by(new FinishedWorkbenchRecipe(new IngredientRecipe(QuarryPlusDataProvider.location("filler"), new ItemStack((ItemLike)Holder.BLOCK_FILLER), 160000000000000L, true, List.of(Recipe.makeList((Tag<Item>)Tags.Items.INGOTS_IRON, 32), Recipe.makeList((ItemLike)Items.f_41963_, 32), Recipe.makeList((ItemLike)Items.f_42386_, 6))))).addCondition(new EnableCondition("filler")));
        return list;
    }

    @NotNull
    private static IngredientList makeList(ItemLike item, int count) {
        return new IngredientList(new IngredientWithCount(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), count));
    }

    @NotNull
    private static IngredientList makeList(Tag<Item> tag, int count) {
        return new IngredientList(new IngredientWithCount(Ingredient.m_43911_(tag), count));
    }

    private List<RecipeSerializeHelper> crafting() {
        ArrayList<RecipeSerializeHelper> list = new ArrayList<RecipeSerializeHelper>();
        list.add(RecipeSerializeHelper.by(ShapedRecipeBuilder.m_126116_((ItemLike)Holder.BLOCK_WORKBENCH).m_126130_("III").m_126130_("GDG").m_126130_("RRR").m_126121_(Character.valueOf('D'), (Tag)Tags.Items.STORAGE_BLOCKS_DIAMOND).m_126127_(Character.valueOf('R'), (ItemLike)Items.f_42451_).m_126121_(Character.valueOf('I'), (Tag)Tags.Items.STORAGE_BLOCKS_IRON).m_126121_(Character.valueOf('G'), (Tag)Tags.Items.STORAGE_BLOCKS_GOLD), null).addCondition(new EnableCondition("workbench")));
        list.add(RecipeSerializeHelper.by(ShapedRecipeBuilder.m_126116_((ItemLike)Holder.BLOCK_FLEX_MARKER).m_126130_("E").m_126130_("T").m_126121_(Character.valueOf('E'), (Tag)Tags.Items.GEMS_EMERALD).m_126127_(Character.valueOf('T'), (ItemLike)Holder.BLOCK_MARKER), null));
        list.add(RecipeSerializeHelper.by(ShapedRecipeBuilder.m_126116_((ItemLike)Holder.BLOCK_16_MARKER).m_126130_("R").m_126130_("T").m_126121_(Character.valueOf('R'), (Tag)Tags.Items.DUSTS_REDSTONE).m_126127_(Character.valueOf('T'), (ItemLike)Holder.BLOCK_MARKER), null));
        list.add(RecipeSerializeHelper.by(ShapelessRecipeBuilder.m_126189_((ItemLike)Holder.ITEM_PUMP_MODULE).m_126209_((ItemLike)Holder.BLOCK_PUMP).m_142409_(MODULE_RECIPE_GROUP), null).addCondition(new EnableCondition("pump_module")));
        list.add(RecipeSerializeHelper.by(ShapelessRecipeBuilder.m_126189_((ItemLike)Holder.ITEM_EXP_MODULE).m_126209_((ItemLike)Holder.BLOCK_EXP_PUMP).m_142409_(MODULE_RECIPE_GROUP), null).addCondition(new EnableCondition("exp_module")));
        list.add(RecipeSerializeHelper.by(ShapelessRecipeBuilder.m_126189_((ItemLike)Holder.ITEM_REPLACER_MODULE).m_126209_((ItemLike)Holder.BLOCK_REPLACER).m_142409_(MODULE_RECIPE_GROUP), null).addCondition(new EnableCondition("replacer_module")));
        list.add(RecipeSerializeHelper.by(ShapedRecipeBuilder.m_126116_((ItemLike)Holder.BLOCK_PLACER).m_126130_("GDG").m_126130_("MRM").m_126130_("MIM").m_126127_(Character.valueOf('D'), (ItemLike)Items.f_41855_).m_126121_(Character.valueOf('R'), (Tag)Tags.Items.DUSTS_REDSTONE).m_126121_(Character.valueOf('I'), (Tag)Tags.Items.INGOTS_IRON).m_126127_(Character.valueOf('M'), (ItemLike)Items.f_41998_).m_126121_(Character.valueOf('G'), (Tag)Tags.Items.INGOTS_GOLD), QuarryPlusDataProvider.location("placer_plus_crafting")).addCondition(new EnableCondition("placer_plus")).addCondition((ICondition)new NotCondition((ICondition)new EnableCondition("workbench"))));
        list.add(RecipeSerializeHelper.by(ShapedRecipeBuilder.m_126116_((ItemLike)Holder.BLOCK_SOLID_FUEL_QUARRY).m_126130_("III").m_126130_("GDG").m_126130_("RRR").m_126121_(Character.valueOf('D'), (Tag)Tags.Items.STORAGE_BLOCKS_GOLD).m_126127_(Character.valueOf('R'), (ItemLike)Items.f_41978_).m_126127_(Character.valueOf('I'), (ItemLike)Items.f_41962_).m_126127_(Character.valueOf('G'), (ItemLike)Items.f_42390_), null).addCondition(new EnableCondition("solid_fuel_quarry")));
        list.add(RecipeSerializeHelper.by(ShapelessRecipeBuilder.m_126189_((ItemLike)Holder.ITEM_FILLER_MODULE).m_126209_((ItemLike)Holder.BLOCK_FILLER).m_142409_(MODULE_RECIPE_GROUP), null).addCondition(new EnableCondition("filler_module")));
        return list;
    }

    private List<RecipeSerializeHelper> debug() {
        List<RecipeSerializeHelper> list = List.of(RecipeSerializeHelper.by(new FinishedWorkbenchRecipe(new IngredientRecipe(Recipe.testLocation("diamond1"), new ItemStack((ItemLike)Items.f_42415_), 640000000000L, true, List.of(Recipe.as((Pair<Ingredient, Integer>)Pair.of((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42329_}), (Object)32), Pair.of((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41905_}), (Object)16)))))), RecipeSerializeHelper.by(new FinishedWorkbenchRecipe(new IngredientRecipe(Recipe.testLocation("diamond2"), new ItemStack((ItemLike)Items.f_42415_, 2), 640000000000L, true, List.of(Recipe.as((Pair<Ingredient, Integer>)Pair.of((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42416_}), (Object)8), Pair.of((Object)Ingredient.m_43911_((Tag)Tags.Items.INGOTS_GOLD), (Object)4)))))), RecipeSerializeHelper.by(ShapelessRecipeBuilder.m_126189_((ItemLike)Items.f_42448_).m_126209_((ItemLike)Items.f_42447_).m_126209_((ItemLike)Items.f_42258_), Recipe.testLocation("bucket_dupe")));
        return list.stream().map(r -> r.addCondition(new QuarryDebugCondition())).toList();
    }

    @SafeVarargs
    private static IngredientList as(Pair<Ingredient, Integer> first, Pair<Ingredient, Integer> ... other) {
        return new IngredientList(Stream.concat(Stream.of(first), Stream.of(other)).map(p -> new IngredientWithCount((Ingredient)p.getKey(), (Integer)p.getRight())).toList());
    }

    private static ResourceLocation testLocation(String path) {
        return QuarryPlusDataProvider.location("test_" + path);
    }

    record FinishedWorkbenchRecipe(WorkbenchRecipe recipe) implements FinishedRecipe
    {
        public void m_7917_(JsonObject object) {
            WorkbenchRecipe.SERIALIZER.toJson(this.recipe, object);
        }

        public ResourceLocation m_6445_() {
            return this.recipe.m_6423_();
        }

        public RecipeSerializer<?> m_6637_() {
            return WorkbenchRecipe.SERIALIZER;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

