/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.yogpc.qp.data.QuarryPlusDataProvider;
import com.yogpc.qp.utils.MapMulti;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import org.jetbrains.annotations.Nullable;

record RecipeSerializeHelper(FinishedRecipe recipe, List<ICondition> conditions, @Nullable ResourceLocation saveName) implements QuarryPlusDataProvider.DataBuilder
{
    @Override
    public ResourceLocation location() {
        return this.saveName == null ? this.recipe.m_6445_() : this.saveName;
    }

    @Override
    public JsonElement build() {
        JsonObject o = this.recipe.m_125966_();
        if (!this.conditions.isEmpty()) {
            o.add("conditions", (JsonElement)this.conditions.stream().map(CraftingHelper::serialize).collect(MapMulti.jsonArrayCollector()));
        }
        return o;
    }

    RecipeSerializeHelper addCondition(ICondition condition) {
        ArrayList<ICondition> copy = new ArrayList<ICondition>(this.conditions);
        copy.add(condition);
        return new RecipeSerializeHelper(this.recipe, copy, this.saveName);
    }

    static RecipeSerializeHelper by(ShapedRecipeBuilder c, ResourceLocation saveName) {
        return new RecipeSerializeHelper(RecipeSerializeHelper.getConsumeValue(c), Collections.emptyList(), saveName);
    }

    static RecipeSerializeHelper by(ShapelessRecipeBuilder c, ResourceLocation saveName) {
        return new RecipeSerializeHelper(RecipeSerializeHelper.getConsumeValue(c), Collections.emptyList(), saveName);
    }

    static RecipeSerializeHelper by(FinishedRecipe recipe) {
        return new RecipeSerializeHelper(recipe, Collections.emptyList(), null);
    }

    static FinishedRecipe getConsumeValue(ShapedRecipeBuilder c) {
        c.m_142284_("dummy", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)QuarryPlusDataProvider.location("dummy")));
        AtomicReference reference = new AtomicReference();
        c.m_176498_(reference::set);
        return (FinishedRecipe)reference.get();
    }

    static FinishedRecipe getConsumeValue(ShapelessRecipeBuilder c) {
        c.m_142284_("dummy", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)QuarryPlusDataProvider.location("dummy")));
        AtomicReference reference = new AtomicReference();
        c.m_176498_(reference::set);
        return (FinishedRecipe)reference.get();
    }
}

