/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.integration.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import com.yogpc.qp.Holder;
import com.yogpc.qp.machines.EnchantableItem;
import com.yogpc.qp.machines.EnchantmentLevel;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

class MoverRecipeCategory
implements IRecipeCategory<MoverRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("quarryplus", "quarryplus.enchantmover");
    private static final ResourceLocation backGround = new ResourceLocation("quarryplus", "textures/gui/mover_jei.png");
    private static final int xOff = 0;
    private static final int yOff = 0;
    private final IGuiHelper helper;
    private final List<ItemStack> pickaxes;

    public MoverRecipeCategory(IGuiHelper helper) {
        this.helper = helper;
        this.pickaxes = List.of(new ItemStack((ItemLike)Items.f_42390_), new ItemStack((ItemLike)Items.f_42395_));
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends MoverRecipe> getRecipeClass() {
        return MoverRecipe.class;
    }

    public Component getTitle() {
        return Holder.BLOCK_MOVER.m_49954_();
    }

    public IDrawable getBackground() {
        return this.helper.createDrawable(backGround, 0, 0, 167, 76);
    }

    public IDrawable getIcon() {
        return this.helper.createDrawableIngredient((Object)new ItemStack((ItemLike)Holder.BLOCK_MOVER));
    }

    public void setIngredients(MoverRecipe recipe, IIngredients ingredients) {
        List<Pair<Enchantment, ItemStack>> input = recipe.makeInput(this.pickaxes);
        List<ItemStack> output = input.stream().map(Pair::getKey).map(recipe::makeOutput).toList();
        ingredients.setInputLists(VanillaTypes.ITEM, Collections.singletonList(input.stream().map(Pair::getValue).toList()));
        ingredients.setOutputLists(VanillaTypes.ITEM, Collections.singletonList(output));
    }

    public void setRecipe(IRecipeLayout recipeLayout, MoverRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup stackGroup = recipeLayout.getItemStacks();
        stackGroup.init(0, true, 3, 30);
        stackGroup.init(1, false, 147, 30);
        stackGroup.set(ingredients);
    }

    public void draw(MoverRecipe recipe, PoseStack stack, double mouseX, double mouseY) {
        super.draw((Object)recipe, stack, mouseX, mouseY);
        List<Enchantment> enchantments = recipe.item.acceptEnchantments().stream().map(e -> new EnchantmentLevel((Enchantment)e, 1)).sorted(EnchantmentLevel.QUARRY_ENCHANTMENT_COMPARATOR).map(EnchantmentLevel::enchantment).toList();
        for (int i = 0; i < enchantments.size(); ++i) {
            TranslatableComponent text = new TranslatableComponent(enchantments.get(i).m_44704_());
            Minecraft.m_91087_().f_91062_.m_92889_(stack, (Component)text, 36.0f, (float)(6 + 10 * i), 0x404040);
        }
    }

    static List<MoverRecipe> recipes() {
        return ForgeRegistries.ITEMS.getValues().stream().filter(i -> i instanceof EnchantableItem).map(i -> new MoverRecipe((EnchantableItem)i, new ItemStack((ItemLike)i))).toList();
    }

    record MoverRecipe(EnchantableItem item, ItemStack stack) {
        List<Pair<Enchantment, ItemStack>> makeInput(List<ItemStack> pickaxes) {
            return this.item.acceptEnchantments().stream().flatMap(e -> pickaxes.stream().map(ItemStack::m_41777_).peek(i -> i.m_41663_(e, e.m_6586_())).map(i -> Pair.of((Object)e, (Object)i))).toList();
        }

        ItemStack makeOutput(Enchantment enchantment) {
            ItemStack s = this.stack.m_41777_();
            s.m_41663_(enchantment, enchantment.m_6586_());
            return s;
        }
    }
}

