/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.EnergyCounter;
import com.yogpc.qp.machines.MachineStorage;
import com.yogpc.qp.machines.PowerConfig;
import com.yogpc.qp.utils.QuarryChunkLoadUtil;
import java.util.Objects;
import java.util.function.LongSupplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class PowerTile
extends BlockEntity
implements IEnergyStorage {
    public static final long ONE_FE = 1000000000L;
    private final EnergyCounter energyCounter;
    private long energy;
    private long maxEnergy;
    @Nullable
    private Boolean chunkPreLoaded = null;
    public final boolean enabled;
    private LazyOptional<IEnergyStorage> energyHandler = LazyOptional.of(() -> this);
    protected final PowerConfig powerConfig;
    private LongSupplier timeProvider;

    public PowerTile(BlockEntityType<?> type, @NotNull BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.enabled = QuarryPlus.config.enableMap.enabled(Objects.requireNonNull(type.getRegistryName()));
        this.energyCounter = EnergyCounter.createInstance(QuarryPlus.config.debug() && this.enabled, "%s(%d, %d, %d)".formatted(((Object)((Object)this)).getClass().getSimpleName(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_()));
        this.powerConfig = PowerConfig.getMachineConfig(Objects.requireNonNull(type.getRegistryName()).m_135815_());
        this.maxEnergy = this.powerConfig.maxEnergy();
        this.setTimeProvider(() -> Objects.requireNonNull(this.f_58857_, "Level in block entity is null. Are you in test?").m_46467_());
    }

    protected final void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128356_("energy", this.energy);
        nbt.m_128356_("maxEnergy", this.maxEnergy);
        if (this.chunkPreLoaded != null) {
            nbt.m_128379_("chunkPreLoaded", this.chunkPreLoaded.booleanValue());
        }
        this.saveNbtData(nbt);
    }

    protected abstract void saveNbtData(CompoundTag var1);

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.energy = nbt.m_128454_("energy");
        if (nbt.m_128441_("maxEnergy")) {
            this.setMaxEnergy(nbt.m_128454_("maxEnergy"));
        }
        if (nbt.m_128425_("chunkPreLoaded", 1)) {
            this.chunkPreLoaded = nbt.m_128471_("chunkPreLoaded");
        }
    }

    public final long getEnergy() {
        return this.energy;
    }

    public final long getMaxEnergy() {
        return this.maxEnergy;
    }

    protected final boolean hasEnoughEnergy() {
        return this.enabled && this.getEnergy() > 0L;
    }

    protected long getMaxReceive() {
        return this.maxEnergy;
    }

    protected final void setMaxEnergy(long maxEnergy) {
        this.maxEnergy = maxEnergy;
    }

    public final long addEnergy(long amount, boolean simulate) {
        long accepted = Math.min(Math.min(this.maxEnergy - this.energy, amount), this.getMaxReceive());
        if (!simulate && accepted != 0L) {
            this.energy += accepted;
            this.energyCounter.getEnergy(this.timeProvider, accepted);
            this.m_6596_();
        }
        return accepted;
    }

    public final boolean useEnergy(long amount, Reason reason, boolean force) {
        if (amount > this.maxEnergy && QuarryPlus.config.debug()) {
            QuarryPlus.LOGGER.warn("{} required {} FE, which is over {}.", (Object)this.energyCounter.name, (Object)(amount / 1000000000L), (Object)this.getMaxEnergyStored());
        }
        if (this.energy >= amount || force) {
            this.energy -= amount;
            this.energyCounter.useEnergy(this.timeProvider, amount, reason);
            this.m_6596_();
            return true;
        }
        return false;
    }

    protected final void setEnergy(long energy, boolean log) {
        if (this.energy > energy) {
            this.energyCounter.useEnergy(log ? this.timeProvider : () -> 1L, this.energy - energy, Reason.FORCE);
        } else {
            this.energyCounter.getEnergy(log ? this.timeProvider : () -> 1L, energy - this.energy);
        }
        this.m_6596_();
        this.energy = energy;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        long accepted = this.addEnergy((long)maxReceive * 1000000000L, simulate);
        int acceptedInFE = (int)(accepted / 1000000000L);
        if (acceptedInFE > maxReceive || acceptedInFE < 0) {
            QuarryPlus.LOGGER.warn("{} got unexpected energy({} FE, {} micro MJ), MaxReceive={}", (Object)this.energyCounter.name, (Object)acceptedInFE, (Object)acceptedInFE, (Object)maxReceive);
            return maxReceive;
        }
        return acceptedInFE;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public final int getEnergyStored() {
        return (int)(this.getEnergy() / 1000000000L);
    }

    public final int getMaxEnergyStored() {
        return (int)(this.getMaxEnergy() / 1000000000L);
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }

    protected final String energyString() {
        return "%sEnergy:%s %f/%d FE (%d)".formatted(ChatFormatting.GREEN, ChatFormatting.RESET, (double)this.getEnergy() / 1.0E9, this.getMaxEnergyStored(), this.getEnergy());
    }

    public PowerConfig getPowerConfig() {
        return this.powerConfig;
    }

    protected void logUsage() {
        this.energyCounter.logUsageMap();
    }

    public final void setChunkPreLoaded(boolean chunkPreLoaded) {
        this.chunkPreLoaded = chunkPreLoaded;
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && this.enabled && this.chunkPreLoaded != null) {
            QuarryChunkLoadUtil.makeChunkUnloaded(this.f_58857_, this.m_58899_(), this.chunkPreLoaded);
        }
    }

    @Nullable
    public static BlockEntityTicker<PowerTile> logTicker() {
        if (QuarryPlus.config.debug()) {
            return (w, p, s, blockEntity) -> blockEntity.energyCounter.logOutput(blockEntity.timeProvider.getAsLong());
        }
        return null;
    }

    @Nullable
    public static BlockEntityTicker<PowerTile> getGenerator() {
        if (((Boolean)QuarryPlus.config.common.noEnergy.get()).booleanValue()) {
            return (w, p, s, tile) -> tile.setEnergy(tile.getMaxEnergy(), true);
        }
        return null;
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.energyHandler.invalidate();
        PowerTile powerTile = this;
        if (powerTile instanceof MachineStorage.HasStorage) {
            MachineStorage.HasStorage storage = (MachineStorage.HasStorage)((Object)powerTile);
            storage.getStorage().itemHandler.invalidate();
            storage.getStorage().fluidHandler.invalidate();
        }
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.energyHandler = LazyOptional.of(() -> this);
        PowerTile powerTile = this;
        if (powerTile instanceof MachineStorage.HasStorage) {
            MachineStorage.HasStorage storage = (MachineStorage.HasStorage)((Object)powerTile);
            storage.getStorage().setHandler();
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            if (this.canReceive() || this.canExtract()) {
                return CapabilityEnergy.ENERGY.orEmpty(cap, this.energyHandler);
            }
        } else {
            PowerTile powerTile;
            if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (powerTile = this) instanceof MachineStorage.HasStorage) {
                MachineStorage.HasStorage storage = (MachineStorage.HasStorage)((Object)powerTile);
                return storage.getStorage().itemHandler.cast();
            }
            if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (powerTile = this) instanceof MachineStorage.HasStorage) {
                MachineStorage.HasStorage storage = (MachineStorage.HasStorage)((Object)powerTile);
                return storage.getStorage().fluidHandler.cast();
            }
        }
        return super.getCapability(cap, side);
    }

    public static boolean stillValid(PowerTile tile, Player player) {
        return tile.f_58857_ != null && tile.m_58899_().m_123309_((Position)player.m_20182_(), true) < 64.0;
    }

    public static boolean isFullFluidBlock(BlockState state) {
        return state.m_60767_().m_76332_();
    }

    @VisibleForTesting
    void setTimeProvider(LongSupplier timeProvider) {
        this.timeProvider = timeProvider;
    }

    public static enum Reason {
        MAKE_FRAME,
        BREAK_BLOCK,
        REMOVE_FLUID,
        MOVE_HEAD,
        ADV_PUMP_FLUID,
        WORKBENCH,
        FORCE,
        EXP_COLLECT,
        BOOK_MOVER,
        ADV_SEARCH,
        MINI_QUARRY,
        FILLER;

    }
}

