/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines;

import com.yogpc.qp.machines.Area;
import com.yogpc.qp.machines.PickIterator;
import net.minecraft.core.Direction;

public abstract class TargetIterator
extends PickIterator<XZPair> {
    protected final Area area;

    TargetIterator(Area area) {
        this.area = area;
        this.reset();
    }

    public static TargetIterator of(Area area) {
        return switch (area.direction()) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH, Direction.UP, Direction.DOWN -> new North(area);
            case Direction.SOUTH -> new South(area);
            case Direction.WEST -> new West(area);
            case Direction.EAST -> new East(area);
        };
    }

    @Override
    public final boolean hasNext() {
        return this.area.minX() < ((XZPair)this.current).x() && ((XZPair)this.current).x() < this.area.maxX() && this.area.minZ() < ((XZPair)this.current).z() && ((XZPair)this.current).z() < this.area.maxZ();
    }

    private static final class North
    extends TargetIterator {
        North(Area area) {
            super(area);
        }

        @Override
        protected XZPair update() {
            if (((XZPair)this.current).z() + 1 >= this.area.maxZ()) {
                return new XZPair(((XZPair)this.current).x() - 1, this.area.minZ() + 1);
            }
            return new XZPair(((XZPair)this.current).x(), ((XZPair)this.current).z() + 1);
        }

        @Override
        public XZPair head() {
            return new XZPair(this.area.maxX() - 1, this.area.minZ() + 1);
        }
    }

    private static final class South
    extends TargetIterator {
        South(Area area) {
            super(area);
        }

        @Override
        protected XZPair update() {
            if (((XZPair)this.current).z() - 1 <= this.area.minZ()) {
                return new XZPair(((XZPair)this.current).x() + 1, this.area.maxZ() - 1);
            }
            return new XZPair(((XZPair)this.current).x(), ((XZPair)this.current).z() - 1);
        }

        @Override
        public XZPair head() {
            return new XZPair(this.area.minX() + 1, this.area.maxZ() - 1);
        }
    }

    private static final class West
    extends TargetIterator {
        West(Area area) {
            super(area);
        }

        @Override
        protected XZPair update() {
            if (((XZPair)this.current).x() + 1 >= this.area.maxX()) {
                return new XZPair(this.area.minX() + 1, ((XZPair)this.current).z() + 1);
            }
            return new XZPair(((XZPair)this.current).x() + 1, ((XZPair)this.current).z());
        }

        @Override
        public XZPair head() {
            return new XZPair(this.area.minX() + 1, this.area.minZ() + 1);
        }
    }

    private static final class East
    extends TargetIterator {
        East(Area area) {
            super(area);
        }

        @Override
        protected XZPair update() {
            if (((XZPair)this.current).x() - 1 <= this.area.minX()) {
                return new XZPair(this.area.maxX() - 1, ((XZPair)this.current).z() - 1);
            }
            return new XZPair(((XZPair)this.current).x() - 1, ((XZPair)this.current).z());
        }

        @Override
        public XZPair head() {
            return new XZPair(this.area.maxX() - 1, this.area.maxZ() - 1);
        }
    }

    public record XZPair(int x, int z) {
    }
}

