/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.marker;

import com.yogpc.qp.Holder;
import com.yogpc.qp.machines.QPBlock;
import com.yogpc.qp.machines.marker.ContainerMarker;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public abstract class BlockExMarker
extends QPBlock
implements EntityBlock {
    private static final VoxelShape STANDING_Shape = Shapes.m_83048_((double)0.35, (double)0.0, (double)0.35, (double)0.65, (double)0.65, (double)0.65);
    public static final String GUI_FLEX_ID = "quarryplus:gui_flex_marker";
    public static final String GUI_16_ID = "quarryplus:gui_marker16";

    public BlockExMarker(String name) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60953_(value -> 7).m_60910_(), name);
    }

    protected abstract void openGUI(Level var1, BlockPos var2, Player var3);

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!player.m_6144_()) {
            if (!world.f_46443_) {
                this.openGUI(world, pos, player);
                return InteractionResult.CONSUME;
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public boolean m_6104_(BlockState state, BlockState stateFrom, Direction direction) {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return STANDING_Shape;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = Direction.UP;
        BlockPos blockPos = pos.m_142300_(direction.m_122424_());
        BlockState blockState = world.m_8055_(blockPos);
        return blockState.m_60783_((BlockGetter)world, blockPos, direction);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos currentPos, BlockPos neighborPos) {
        return state.m_60710_((LevelReader)world, currentPos) ? state : Blocks.f_50016_.m_49966_();
    }

    public abstract void m_6402_(Level var1, BlockPos var2, BlockState var3, @Nullable LivingEntity var4, ItemStack var5);

    public abstract BlockEntity m_142194_(BlockPos var1, BlockState var2);

    public static class Range {
        private final float min;
        private final float max;
        private final float distance;

        public Range(float min, float max) {
            this.min = min;
            this.max = max;
            if (max < min) {
                throw new IllegalArgumentException(String.format("min is grater than max. Min: %f, Max:%f", Float.valueOf(min), Float.valueOf(max)));
            }
            this.distance = max - min;
        }

        public float convert(float f) {
            if (f < this.min) {
                int i = (int)((this.min - f) / this.distance) + 1;
                return this.convert(f + this.distance * (float)i);
            }
            if (f >= this.max) {
                int i = (int)((f - this.max) / this.distance) + 1;
                return this.convert(f - this.distance * (float)i);
            }
            return f;
        }
    }

    private record InteractionObject(BlockPos pos, MenuType<?> type, String name) implements MenuProvider
    {
        public Component m_5446_() {
            return new TranslatableComponent(this.name);
        }

        public AbstractContainerMenu m_7208_(int syncId, Inventory inv, Player player) {
            return new ContainerMarker(syncId, player, this.pos, this.type);
        }
    }

    public static class Block16Marker
    extends BlockExMarker {
        private static final Range RANGE = new Range(0.0f, 360.0f);
        public static final String NAME = "marker16";

        public Block16Marker() {
            super(NAME);
        }

        @Override
        protected void openGUI(Level worldIn, BlockPos pos, Player playerIn) {
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)playerIn), (MenuProvider)new InteractionObject(pos, Holder.MARKER_16_MENU_TYPE, this.m_7705_()), (BlockPos)pos);
        }

        @Override
        public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
            float angle = RANGE.convert(placer != null ? placer.m_6080_() : 0.0f);
            Direction.AxisDirection z = angle < 90.0f || angle >= 270.0f ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE;
            Direction.AxisDirection x = angle > 180.0f ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE;
            level.m_141902_(pos, Holder.MARKER_16_TYPE).ifPresent(t -> t.init(x, z));
        }

        @Override
        public BlockEntity m_142194_(BlockPos pos, BlockState state) {
            return Holder.MARKER_16_TYPE.m_155264_(pos, state);
        }
    }

    public static class BlockFlexMarker
    extends BlockExMarker {
        public static final String NAME = "flex_marker";

        public BlockFlexMarker() {
            super(NAME);
        }

        @Override
        public BlockEntity m_142194_(BlockPos pos, BlockState state) {
            return Holder.FLEX_MARKER_TYPE.m_155264_(pos, state);
        }

        @Override
        protected void openGUI(Level worldIn, BlockPos pos, Player playerIn) {
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)playerIn), (MenuProvider)new InteractionObject(pos, Holder.FLEX_MARKER_MENU_TYPE, this.m_7705_()), (BlockPos)pos);
        }

        @Override
        public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
            float rotationYawHead = placer != null ? placer.m_6080_() : 0.0f;
            level.m_141902_(pos, Holder.FLEX_MARKER_TYPE).ifPresent(t -> t.init(Direction.m_122364_((double)rotationYawHead)));
        }
    }
}

