/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.marker;

import com.yogpc.qp.Holder;
import com.yogpc.qp.machines.Area;
import com.yogpc.qp.machines.CheckerLog;
import com.yogpc.qp.machines.QuarryMarker;
import com.yogpc.qp.render.Box;
import com.yogpc.qp.render.RenderMarker;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class Tile16Marker
extends BlockEntity
implements QuarryMarker,
CheckerLog {
    private BlockPos min = BlockPos.f_121853_;
    private BlockPos max = BlockPos.f_121853_;
    @Nullable
    public Box[] boxes;
    private Direction.AxisDirection xDirection = Direction.AxisDirection.NEGATIVE;
    private Direction.AxisDirection zDirection = Direction.AxisDirection.POSITIVE;
    private int size = 16;

    public Tile16Marker(BlockPos pos, BlockState state) {
        super(Holder.MARKER_16_TYPE, pos, state);
    }

    public void init(Direction.AxisDirection xDirection, Direction.AxisDirection zDirection) {
        this.xDirection = Objects.requireNonNull(xDirection);
        this.zDirection = Objects.requireNonNull(zDirection);
        this.changeSize(this.size);
    }

    public void changeSize(int size) {
        int y = this.m_58899_().m_123342_();
        this.changeSize(size, y, y);
    }

    public void changeSize(int size, int yMax, int yMin) {
        this.size = size;
        BlockPos edge1 = this.m_58899_().m_142082_(this.xDirection.m_122540_() * (size + 1), 0, this.zDirection.m_122540_() * (size + 1));
        BlockPos edge2 = this.m_58899_();
        this.min = new BlockPos(Math.min(edge1.m_123341_(), edge2.m_123341_()), yMin, Math.min(edge1.m_123343_(), edge2.m_123343_()));
        this.max = new BlockPos(Math.max(edge1.m_123341_(), edge2.m_123341_()), yMax, Math.max(edge1.m_123343_(), edge2.m_123343_()));
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.setRender();
        }
    }

    private void setRender() {
        this.boxes = RenderMarker.getRenderBox(new Area((Vec3i)this.min, (Vec3i)this.max, Direction.m_122387_((Direction.Axis)Direction.Axis.X, (Direction.AxisDirection)this.xDirection)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getSize() {
        return this.size;
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.min = BlockPos.m_122022_((long)compound.m_128454_("min"));
        this.max = BlockPos.m_122022_((long)compound.m_128454_("max"));
        this.xDirection = compound.m_128471_("x") ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE;
        this.zDirection = compound.m_128471_("z") ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE;
        this.size = compound.m_128451_("size");
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.setRender();
        }
    }

    protected void m_183515_(CompoundTag compound) {
        compound.m_128356_("min", this.min.m_121878_());
        compound.m_128356_("max", this.max.m_121878_());
        compound.m_128379_("x", this.xDirection == Direction.AxisDirection.POSITIVE);
        compound.m_128379_("z", this.zDirection == Direction.AxisDirection.POSITIVE);
        compound.m_128405_("size", this.size);
        super.m_183515_(compound);
    }

    public BlockPos min() {
        return this.min == BlockPos.f_121853_ ? this.m_58899_() : this.min;
    }

    public BlockPos max() {
        return this.max == BlockPos.f_121853_ ? this.m_58899_() : this.max;
    }

    @Override
    public List<? extends Component> getDebugLogs() {
        return Stream.of("Size: " + this.size, "Min: " + this.min(), "Max: " + this.max()).map(TextComponent::new).toList();
    }

    @Override
    public Optional<Area> getArea() {
        return Optional.of(new Area((Vec3i)this.min, (Vec3i)this.max, Direction.m_122387_((Direction.Axis)Direction.Axis.X, (Direction.AxisDirection)this.xDirection)));
    }

    @Override
    public List<ItemStack> removeAndGetItems() {
        assert (this.f_58857_ != null);
        this.f_58857_.m_7471_(this.m_58899_(), false);
        return List.of(new ItemStack((ItemLike)Holder.BLOCK_16_MARKER));
    }
}

