/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.marker;

import com.yogpc.qp.Holder;
import com.yogpc.qp.machines.Area;
import com.yogpc.qp.machines.CheckerLog;
import com.yogpc.qp.machines.QuarryMarker;
import com.yogpc.qp.packet.ClientSync;
import com.yogpc.qp.packet.ClientSyncMessage;
import com.yogpc.qp.packet.PacketHandler;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileMarker
extends BlockEntity
implements QuarryMarker,
CheckerLog,
ClientSync {
    public static final int MAX_SEARCH = 256;
    private MarkerConnection markerConnection = MarkerConnection.EMPTY;
    public boolean rsReceiving;

    public TileMarker(BlockPos pos, BlockState state) {
        super(Holder.MARKER_TYPE, pos, state);
    }

    void tryConnect(boolean first) {
        assert (this.m_58904_() != null);
        Optional zMarker = IntStream.range(1, 256).flatMap(i -> IntStream.of(i, -i)).mapToObj(i -> this.m_58899_().m_5484_(Direction.NORTH, i)).flatMap(p -> this.m_58904_().m_141902_(p, Holder.MARKER_TYPE).stream()).findFirst();
        Optional xMarker = IntStream.range(1, 256).flatMap(i -> IntStream.of(i, -i)).mapToObj(i -> this.m_58899_().m_5484_(Direction.EAST, i)).flatMap(p -> this.m_58904_().m_141902_(p, Holder.MARKER_TYPE).stream()).findFirst();
        MarkerConnection.set(this, xMarker.orElse(null), zMarker.orElse(null));
        if (first && this.markerConnection == MarkerConnection.EMPTY) {
            xMarker.ifPresent(marker -> marker.tryConnect(false));
        }
        if (first && this.markerConnection == MarkerConnection.EMPTY) {
            zMarker.ifPresent(marker -> marker.tryConnect(false));
        }
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.markerConnection.markerPlaces().stream().flatMap(p -> this.f_58857_.m_141902_(p, Holder.MARKER_TYPE).stream()).forEach(TileMarker::resetConnection);
        }
    }

    private static void resetConnection(TileMarker m) {
        m.markerConnection = MarkerConnection.EMPTY;
        m.sync();
    }

    @Override
    public Optional<Area> getArea() {
        return this.markerConnection.getArea();
    }

    @OnlyIn(value=Dist.CLIENT)
    public Optional<Area> renderArea() {
        if (this.markerConnection.render()) {
            return this.getArea();
        }
        return Optional.empty();
    }

    @Override
    public List<ItemStack> removeAndGetItems() {
        assert (this.m_58904_() != null);
        int count = this.markerConnection.markerPlaces().size();
        this.markerConnection.markerPlaces().forEach(p -> this.m_58904_().m_7471_(p, false));
        return List.of(new ItemStack((ItemLike)Holder.BLOCK_MARKER, count));
    }

    @Override
    public List<? extends Component> getDebugLogs() {
        return List.of(new TextComponent("%sMarker Area%s: %s".formatted(ChatFormatting.AQUA, ChatFormatting.RESET, this.markerConnection.getArea())), new TextComponent("%sMarker Poses%s: %s".formatted(ChatFormatting.AQUA, ChatFormatting.RESET, this.markerConnection.markerPlaces())));
    }

    @Override
    public void fromClientTag(CompoundTag tag) {
        this.markerConnection = MarkerConnection.fromClientNbt(tag.m_128469_("markerConnection"));
        this.rsReceiving = tag.m_128471_("rsReceiving");
    }

    @Override
    public CompoundTag toClientTag(CompoundTag tag) {
        tag.m_128365_("markerConnection", (Tag)this.markerConnection.toClientNbt());
        tag.m_128379_("rsReceiving", this.rsReceiving);
        return tag;
    }

    void sync() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            PacketHandler.sendToClient(new ClientSyncMessage(this), this.f_58857_);
        }
    }

    record MarkerConnection(@Nullable Area area, @NotNull Set<BlockPos> markerPlaces, boolean render) {
        static final MarkerConnection EMPTY = new MarkerConnection(null, Collections.emptySet(), false);

        static void set(TileMarker thisMarker, @Nullable TileMarker xMarker, @Nullable TileMarker zMarker) {
            if (xMarker != null && zMarker != null) {
                MarkerConnection connectionParent = new MarkerConnection(new Area((Vec3i)xMarker.m_58899_(), (Vec3i)zMarker.m_58899_().m_6630_(4), Direction.UP), Set.of(thisMarker.m_58899_(), xMarker.m_58899_(), zMarker.m_58899_()), true);
                MarkerConnection connectionChild = new MarkerConnection(new Area((Vec3i)xMarker.m_58899_(), (Vec3i)zMarker.m_58899_().m_6630_(4), Direction.UP), Set.of(thisMarker.m_58899_(), xMarker.m_58899_(), zMarker.m_58899_()), false);
                thisMarker.markerConnection = connectionParent;
                xMarker.markerConnection = connectionChild;
                zMarker.markerConnection = connectionChild;
                thisMarker.sync();
                xMarker.sync();
                zMarker.sync();
            }
        }

        Optional<Area> getArea() {
            return Optional.ofNullable(this.area);
        }

        CompoundTag toClientNbt() {
            CompoundTag tag = new CompoundTag();
            if (this.area != null) {
                tag.m_128365_("area", (Tag)this.area.toNBT());
            }
            tag.m_128379_("render", this.render);
            return tag;
        }

        static MarkerConnection fromClientNbt(CompoundTag tag) {
            Optional area;
            Optional<Object> optional = area = tag.m_128441_("area") ? Area.fromNBT(tag.m_128469_("area")) : Optional.empty();
            if (area.isEmpty()) {
                return EMPTY;
            }
            return new MarkerConnection(area.orElse(null), Collections.emptySet(), tag.m_128471_("render"));
        }
    }
}

