/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.mini_quarry;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.yogpc.qp.QuarryPlus;
import java.util.Locale;
import net.minecraft.commands.arguments.blocks.BlockPredicateArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

interface BlockStatePredicate {
    public boolean test(BlockState var1, BlockGetter var2, BlockPos var3);

    public static BlockStatePredicate air() {
        return Air.INSTANCE;
    }

    public static BlockStatePredicate fluid() {
        return Fluid.INSTANCE;
    }

    public static BlockStatePredicate name(ResourceLocation location) {
        return new Name(location);
    }

    public static BlockStatePredicate tag(ResourceLocation location) {
        return new Tag(location);
    }

    public static BlockStatePredicate predicateString(String location) {
        return new VanillaBlockPredicate(location);
    }

    public static BlockStatePredicate all() {
        return All.INSTANCE;
    }

    public static BlockStatePredicate fromTag(CompoundTag tag) {
        String type;
        return switch (type = tag.m_128461_("type")) {
            case "all" -> BlockStatePredicate.all();
            case "air" -> BlockStatePredicate.air();
            case "fluid" -> BlockStatePredicate.fluid();
            case "name" -> BlockStatePredicate.name(new ResourceLocation(tag.m_128461_("location")));
            case "tag" -> BlockStatePredicate.tag(new ResourceLocation(tag.m_128461_("location")));
            case "vanilla" -> BlockStatePredicate.predicateString(tag.m_128461_("predicate"));
            default -> throw new IllegalArgumentException("invalid type name: %s, got from %s".formatted(type, tag));
        };
    }

    public CompoundTag toTag();

    public static final class Air
    implements BlockStatePredicate {
        private static final Air INSTANCE = new Air();

        private Air() {
        }

        @Override
        public boolean test(BlockState state, BlockGetter level, BlockPos pos) {
            return state.m_60795_();
        }

        @Override
        public CompoundTag toTag() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("type", this.toString().toLowerCase(Locale.ROOT));
            return tag;
        }

        public String toString() {
            return "Air";
        }
    }

    public static final class Fluid
    implements BlockStatePredicate {
        private static final Fluid INSTANCE = new Fluid();

        private Fluid() {
        }

        @Override
        public boolean test(BlockState state, BlockGetter level, BlockPos pos) {
            return !state.m_60819_().m_76178_();
        }

        @Override
        public CompoundTag toTag() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("type", this.toString().toLowerCase(Locale.ROOT));
            return tag;
        }

        public String toString() {
            return "Fluid";
        }
    }

    public record Name(ResourceLocation location) implements BlockStatePredicate
    {
        @Override
        public boolean test(BlockState state, BlockGetter level, BlockPos pos) {
            return this.location.equals((Object)state.m_60734_().getRegistryName());
        }

        @Override
        public CompoundTag toTag() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("type", "name");
            tag.m_128359_("location", this.location.toString());
            return tag;
        }

        @Override
        public String toString() {
            return "Name{location=" + this.location + "}";
        }
    }

    public static final class Tag
    implements BlockStatePredicate {
        private final net.minecraft.tags.Tag<Block> tag;
        private final ResourceLocation location;

        private Tag(ResourceLocation tagName) {
            this.location = tagName;
            this.tag = BlockTags.m_13115_().m_13404_(tagName);
        }

        @Override
        public boolean test(BlockState state, BlockGetter level, BlockPos pos) {
            return this.tag.m_8110_((Object)state.m_60734_());
        }

        @Override
        public CompoundTag toTag() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("type", "tag");
            tag.m_128359_("location", this.location.toString());
            return tag;
        }

        public String toString() {
            return "Tag{" + this.location + "}";
        }
    }

    public static final class VanillaBlockPredicate
    implements BlockStatePredicate {
        private static final Logger LOGGER = QuarryPlus.getLogger(VanillaBlockPredicate.class);
        private final String blockPredicate;
        @Nullable
        private BlockPredicateArgument.Result argument;

        public VanillaBlockPredicate(String blockPredicate) {
            this.blockPredicate = blockPredicate;
            try {
                this.argument = BlockPredicateArgument.m_115570_().parse(new StringReader(blockPredicate));
            }
            catch (CommandSyntaxException e) {
                LOGGER.warn("Caught invalid BlockState predicate.", (Throwable)e);
                this.argument = null;
            }
        }

        @Override
        public boolean test(BlockState state, BlockGetter blockGetter, BlockPos pos) {
            if (this.argument != null && blockGetter instanceof Level) {
                Level level = (Level)blockGetter;
                try {
                    return this.argument.m_115602_(level.m_5999_()).test(new BlockInWorld((LevelReader)level, pos, true));
                }
                catch (CommandSyntaxException e) {
                    LOGGER.warn("Caught error in creating predicate.", (Throwable)e);
                    return false;
                }
            }
            return false;
        }

        @Override
        public CompoundTag toTag() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("type", "vanilla");
            tag.m_128359_("predicate", this.blockPredicate);
            return tag;
        }

        public String toString() {
            return "VanillaBlockPredicate{blockPredicate='" + this.blockPredicate + "'valid=" + (this.argument != null) + "}";
        }
    }

    public static final class All
    implements BlockStatePredicate {
        private static final All INSTANCE = new All();

        private All() {
        }

        @Override
        public boolean test(BlockState state, BlockGetter level, BlockPos pos) {
            return true;
        }

        @Override
        public CompoundTag toTag() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("type", this.toString().toLowerCase(Locale.ROOT));
            return tag;
        }

        public String toString() {
            return "All";
        }
    }
}

