/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.placer;

import com.yogpc.qp.Holder;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.CheckerLog;
import com.yogpc.qp.machines.QuarryFakePlayer;
import com.yogpc.qp.machines.placer.PlacerBlock;
import com.yogpc.qp.machines.placer.PlacerContainer;
import com.yogpc.qp.packet.PacketHandler;
import com.yogpc.qp.packet.TileMessage;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlacerTile
extends BlockEntity
implements Container,
CheckerLog,
MenuProvider {
    public static final String KEY_ITEM = "items";
    public static final String KEY_LAST_PLACED = "last_placed";
    public static final String KEY_RS_MODE = "redstone_mode";
    public static final Map<Direction, Vec3> DIRECTION_VEC3D_MAP;
    private final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
    private int lastPlacedIndex = 0;
    public RedstoneMode redstoneMode = RedstoneMode.PULSE;
    private final IItemHandler itemHandler = new InvWrapper((Container)this);
    private final LazyOptional<IItemHandler> itemHandlerOpt = LazyOptional.of(() -> this.itemHandler);
    private static final int PULSE_ID = 0;
    private static final int RS_IGNORE_ID = 1;
    private static final int RS_ON_ID = 2;
    private static final int RS_OFF_ID = 3;

    public PlacerTile(BlockPos pos, BlockState state) {
        super(Holder.PLACER_TYPE, pos, state);
    }

    public void tick() {
        Direction facing;
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && this.redstoneMode.isAlways() && this.redstoneMode.shouldWork(() -> this.lambda$tick$0(facing = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_)))) {
            if (this.f_58857_.m_8055_(this.m_58899_().m_142300_(facing)).m_60795_()) {
                this.placeBlock();
            } else {
                this.breakBlock();
            }
        }
    }

    void breakBlock() {
        if (this.f_58857_ == null || !this.redstoneMode.canBreak()) {
            return;
        }
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
        BlockPos pos = this.m_58899_().m_142300_(facing);
        BlockState state = this.f_58857_.m_8055_(pos);
        if (state.m_60800_((BlockGetter)this.f_58857_, pos) < 0.0f) {
            return;
        }
        FakePlayer fake = QuarryFakePlayer.get((ServerLevel)this.f_58857_);
        fake.m_21008_(InteractionHand.MAIN_HAND, PlacerTile.getSilkPickaxe());
        List drops = Block.m_49874_((BlockState)state, (ServerLevel)((ServerLevel)this.f_58857_), (BlockPos)pos, (BlockEntity)this.f_58857_.m_7702_(pos), (Entity)fake, (ItemStack)fake.m_21205_());
        this.f_58857_.m_7471_(pos, false);
        drops.stream().map(s -> ItemHandlerHelper.insertItem((IItemHandler)this.itemHandler, (ItemStack)s, (boolean)false)).filter(Predicate.not(ItemStack::m_41619_)).forEach(s -> Block.m_49840_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (ItemStack)s));
    }

    void placeBlock() {
        if (this.m_7983_() || !this.redstoneMode.canPlace()) {
            return;
        }
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
        BlockPos pos = this.m_58899_().m_142300_(facing);
        Vec3 hitPos = DIRECTION_VEC3D_MAP.get(facing.m_122424_()).m_82520_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        BlockHitResult rayTrace = new BlockHitResult(hitPos, facing.m_122424_(), pos, false);
        FakePlayer fake = QuarryFakePlayer.get((ServerLevel)this.f_58857_);
        PlacerTile.findEntry(this.inventory, arg_0 -> PlacerTile.lambda$placeBlock$3((Player)fake, rayTrace, arg_0), this.lastPlacedIndex).ifPresent(i -> {
            this.lastPlacedIndex = !this.m_8020_(i).m_41619_() ? i : PlacerTile.findEntry(this.inventory, s -> !s.m_41619_() && s.m_41720_() instanceof BlockItem, i).orElse(0);
            this.m_6596_();
            this.sendPacket();
        });
        fake.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
    }

    public static <T> OptionalInt findEntry(List<T> check, Predicate<T> filter, int startIndex) {
        int listSize = check.size();
        if (startIndex >= listSize) {
            return OptionalInt.empty();
        }
        return PlacerTile.findEntryInternal(check, filter, startIndex, startIndex, listSize);
    }

    private static <T> OptionalInt findEntryInternal(List<T> check, Predicate<T> filter, int startIndex, int index, int listSize) {
        T value = check.get(index);
        if (filter.test(value)) {
            return OptionalInt.of(index);
        }
        if (index == startIndex - 1 || startIndex == 0 && index == listSize - 1) {
            return OptionalInt.empty();
        }
        int next = index + 1 == listSize ? 0 : index + 1;
        return PlacerTile.findEntryInternal(check, filter, startIndex, next, listSize);
    }

    static boolean tryPlaceItem(ItemStack stack, Player fake, BlockHitResult rayTrace) {
        if (stack.m_41619_()) {
            return false;
        }
        Item item = stack.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            fake.m_21008_(InteractionHand.MAIN_HAND, stack);
            BlockPlaceContext context = new BlockPlaceContext(new UseOnContext(fake, InteractionHand.MAIN_HAND, rayTrace));
            return blockItem.m_40576_(context).m_19077_();
        }
        return false;
    }

    public int getLastPlacedIndex() {
        return this.lastPlacedIndex;
    }

    void sendPacket() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            PacketHandler.sendToClient(new TileMessage(this), this.f_58857_);
        }
    }

    private static ItemStack getSilkPickaxe() {
        ItemStack stack = new ItemStack((ItemLike)Items.f_42390_);
        stack.m_41663_(Enchantments.f_44985_, 1);
        return stack;
    }

    protected void m_183515_(CompoundTag compound) {
        compound.m_128365_(KEY_ITEM, (Tag)ContainerHelper.m_18973_((CompoundTag)new CompoundTag(), this.inventory));
        compound.m_128405_(KEY_LAST_PLACED, this.lastPlacedIndex);
        compound.m_128359_(KEY_RS_MODE, this.redstoneMode.name());
        super.m_183515_(compound);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        ContainerHelper.m_18980_((CompoundTag)compound.m_128469_(KEY_ITEM), this.inventory);
        this.lastPlacedIndex = compound.m_128451_(KEY_LAST_PLACED);
        try {
            this.redstoneMode = RedstoneMode.valueOf(compound.m_128461_(KEY_RS_MODE));
        }
        catch (IllegalArgumentException e) {
            QuarryPlus.LOGGER.error("Illegal name(%s) was passed to placer mode.".formatted(compound.m_128461_(KEY_RS_MODE)), (Throwable)e);
            this.redstoneMode = RedstoneMode.PULSE;
        }
    }

    public CompoundTag m_5995_() {
        return this.serializeNBT();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(cap, this.itemHandlerOpt);
        }
        return super.getCapability(cap, side);
    }

    public Component m_5446_() {
        return this.m_58900_().m_60734_().m_49954_();
    }

    @Override
    public List<? extends Component> getDebugLogs() {
        return Stream.of("RS Mode: " + this.redstoneMode.toString(), "Last Placed: " + this.getLastPlacedIndex(), "Inv: " + this.inventory.stream().filter(s -> !s.m_41619_()).count()).map(TextComponent::new).collect(Collectors.toList());
    }

    public int m_6643_() {
        return 9;
    }

    public boolean m_7983_() {
        return this.inventory.stream().allMatch(ItemStack::m_41619_);
    }

    public ItemStack m_8020_(int index) {
        if (index >= 0 && index < this.m_6643_()) {
            return (ItemStack)this.inventory.get(index);
        }
        return ItemStack.f_41583_;
    }

    public ItemStack m_7407_(int index, int count) {
        return ContainerHelper.m_18969_(this.inventory, (int)index, (int)count);
    }

    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.inventory, (int)index);
    }

    public void m_6836_(int index, ItemStack stack) {
        if (index >= 0 && index < this.m_6643_()) {
            this.inventory.set(index, (Object)stack);
        }
    }

    public boolean m_6542_(Player player) {
        return this.f_58857_ != null && this.m_58899_().m_123309_((Position)player.m_20182_(), true) < 64.0;
    }

    public void m_6211_() {
        this.inventory.clear();
    }

    public int m_6893_() {
        return 64;
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return true;
    }

    public PlacerContainer createMenu(int id, Inventory p, Player player) {
        return new PlacerContainer(id, player, this.m_58899_());
    }

    public void cycleRedstoneMode() {
        this.redstoneMode = RedstoneMode.cycle(this.redstoneMode);
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.sendPacket();
        }
    }

    private static /* synthetic */ boolean lambda$placeBlock$3(Player fake, BlockHitResult rayTrace, ItemStack i) {
        return PlacerTile.tryPlaceItem(i, fake, rayTrace);
    }

    private /* synthetic */ boolean lambda$tick$0(Direction facing) {
        return PlacerBlock.isPoweredToWork(this.f_58857_, this.m_58899_(), facing);
    }

    static {
        EnumMap<Direction, Vec3> map = new EnumMap<Direction, Vec3>(Direction.class);
        map.put(Direction.DOWN, new Vec3(0.5, 0.0, 0.5));
        map.put(Direction.UP, new Vec3(0.5, 1.0, 0.5));
        map.put(Direction.NORTH, new Vec3(0.5, 0.5, 0.0));
        map.put(Direction.SOUTH, new Vec3(0.5, 0.5, 1.0));
        map.put(Direction.EAST, new Vec3(1.0, 0.5, 0.5));
        map.put(Direction.WEST, new Vec3(0.0, 0.5, 0.5));
        DIRECTION_VEC3D_MAP = Collections.unmodifiableMap(map);
    }

    public static enum RedstoneMode {
        PULSE(0, true, true),
        PULSE_PLACE_ONLY(0, true, false),
        PULSE_BREAK_ONLY(0, false, true);

        private final int modeID;
        private final boolean placeEnabled;
        private final boolean breakEnabled;

        private RedstoneMode(int modeID, boolean placeEnabled, boolean breakEnabled) {
            this.modeID = modeID;
            this.placeEnabled = placeEnabled;
            this.breakEnabled = breakEnabled;
        }

        public String toString() {
            return this.name().replace('_', ' ');
        }

        public boolean isAlways() {
            return this.modeID == 1 || this.modeID == 2 || this.modeID == 3;
        }

        public boolean isPulse() {
            return this.modeID == 0;
        }

        public boolean canPlace() {
            return this.placeEnabled;
        }

        public boolean canBreak() {
            return this.breakEnabled;
        }

        public boolean isRsOn() {
            return this.modeID == 2;
        }

        public boolean isRsOff() {
            return this.modeID == 3;
        }

        public boolean shouldWork(BooleanSupplier powered) {
            if (this.isRsOn()) {
                return powered.getAsBoolean();
            }
            if (this.isRsOff()) {
                return !powered.getAsBoolean();
            }
            return true;
        }

        public static RedstoneMode cycle(RedstoneMode now) {
            RedstoneMode[] modes = RedstoneMode.values();
            for (int i = 0; i < modes.length; ++i) {
                RedstoneMode mode = modes[i];
                if (mode != now) continue;
                if (i + 1 == modes.length) {
                    return modes[0];
                }
                return modes[i + 1];
            }
            return modes[0];
        }
    }
}

