/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.quarry;

import com.yogpc.qp.machines.Direction8;
import com.yogpc.qp.machines.QPBlock;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FrameBlock
extends QPBlock {
    public static final String NAME = "frame";
    public static final BooleanProperty DAMMING = BooleanProperty.m_61465_((String)"damming");
    public static final VoxelShape BOX_AABB = Shapes.m_83048_((double)0.25, (double)0.25, (double)0.25, (double)0.75, (double)0.75, (double)0.75);
    public static final VoxelShape North_AABB = Shapes.m_83048_((double)0.25, (double)0.25, (double)0.0, (double)0.75, (double)0.75, (double)0.25);
    public static final VoxelShape South_AABB = Shapes.m_83048_((double)0.25, (double)0.25, (double)0.75, (double)0.75, (double)0.75, (double)1.0);
    public static final VoxelShape West_AABB = Shapes.m_83048_((double)0.0, (double)0.25, (double)0.25, (double)0.25, (double)0.75, (double)0.75);
    public static final VoxelShape East_AABB = Shapes.m_83048_((double)0.75, (double)0.25, (double)0.25, (double)1.0, (double)0.75, (double)0.75);
    public static final VoxelShape UP_AABB = Shapes.m_83048_((double)0.25, (double)0.75, (double)0.25, (double)0.75, (double)1.0, (double)0.75);
    public static final VoxelShape Down_AABB = Shapes.m_83048_((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.25, (double)0.75);
    private static final Map<BooleanProperty, VoxelShape> SHAPE_MAP = Map.of(BlockStateProperties.f_61368_, North_AABB, BlockStateProperties.f_61370_, South_AABB, BlockStateProperties.f_61371_, West_AABB, BlockStateProperties.f_61369_, East_AABB, BlockStateProperties.f_61366_, UP_AABB, BlockStateProperties.f_61367_, Down_AABB);
    private static final BiPredicate<Level, BlockPos> HAS_NEIGHBOUR_LIQUID = (world, pos) -> Stream.of(Direction.values()).map(arg_0 -> ((BlockPos)pos).m_142300_(arg_0)).anyMatch(p -> !world.m_6425_(p).m_76178_());
    private boolean breaking = false;

    public FrameBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76275_).m_60978_(0.5f).m_60993_(), NAME);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)BlockStateProperties.f_61368_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61369_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61370_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61371_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61366_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61367_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DAMMING, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStateProperties.f_61368_, BlockStateProperties.f_61369_, BlockStateProperties.f_61370_, BlockStateProperties.f_61371_, BlockStateProperties.f_61366_, BlockStateProperties.f_61367_, DAMMING});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level worldIn = context.m_43725_();
        BlockPos pos = context.m_8083_();
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61368_, (Comparable)Boolean.valueOf(this.canConnectTo((BlockGetter)worldIn, pos.m_142127_())))).m_61124_((Property)BlockStateProperties.f_61369_, (Comparable)Boolean.valueOf(this.canConnectTo((BlockGetter)worldIn, pos.m_142126_())))).m_61124_((Property)BlockStateProperties.f_61370_, (Comparable)Boolean.valueOf(this.canConnectTo((BlockGetter)worldIn, pos.m_142128_())))).m_61124_((Property)BlockStateProperties.f_61371_, (Comparable)Boolean.valueOf(this.canConnectTo((BlockGetter)worldIn, pos.m_142125_())))).m_61124_((Property)BlockStateProperties.f_61367_, (Comparable)Boolean.valueOf(this.canConnectTo((BlockGetter)worldIn, pos.m_7495_())))).m_61124_((Property)BlockStateProperties.f_61366_, (Comparable)Boolean.valueOf(this.canConnectTo((BlockGetter)worldIn, pos.m_7494_())));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos currentPos, BlockPos neighborPos) {
        return (BlockState)state.m_61124_((Property)PipeBlock.f_55154_.get(direction), (Comparable)Boolean.valueOf(this.canConnectTo((BlockGetter)world, currentPos.m_142300_(direction))));
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (state.m_60734_() != newState.m_60734_()) {
            if (!this.breaking) {
                this.breaking = true;
                if (!HAS_NEIGHBOUR_LIQUID.test(world, pos)) {
                    this.breakChain(world, pos);
                }
                this.breaking = false;
            }
            super.m_6810_(state, world, pos, newState, moved);
        }
    }

    private void breakChain(Level world, BlockPos first) {
        if (!world.f_46443_) {
            HashSet<BlockPos> set = new HashSet<BlockPos>();
            set.add(first);
            ArrayList<BlockPos> nextCheck = new ArrayList<BlockPos>();
            nextCheck.add(first);
            while (!nextCheck.isEmpty()) {
                List list = (List)nextCheck.clone();
                nextCheck.clear();
                for (BlockPos pos2 : list) {
                    for (Direction8 dir : Direction8.DIRECTIONS) {
                        BlockPos nPos = pos2.m_141952_(dir.vec());
                        BlockState nBlock = world.m_8055_(nPos);
                        if (nBlock.m_60734_() != this || HAS_NEIGHBOUR_LIQUID.test(world, nPos) || !set.add(nPos)) continue;
                        nextCheck.add(nPos);
                    }
                }
            }
            set.forEach(pos -> world.m_7471_(pos, false));
        }
    }

    private boolean canConnectTo(BlockGetter worldIn, BlockPos pos) {
        return worldIn.m_8055_(pos).m_60734_() == this;
    }

    public boolean m_6104_(BlockState state, BlockState stateFrom, Direction direction) {
        return true;
    }

    public BlockState getDammingState() {
        return (BlockState)this.m_49966_().m_61124_((Property)DAMMING, (Comparable)Boolean.valueOf(true));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE_MAP.entrySet().stream().filter(e -> (Boolean)state.m_61143_((Property)e.getKey())).map(Map.Entry::getValue).reduce(BOX_AABB, Shapes::m_83110_);
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        super.m_6861_(state, world, pos, block, fromPos, notify);
        if (((Boolean)state.m_61143_((Property)DAMMING)).booleanValue()) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)DAMMING, (Comparable)Boolean.valueOf(HAS_NEIGHBOUR_LIQUID.test(world, pos))), 2);
        }
    }
}

