/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.quarry;

import com.yogpc.qp.machines.Area;
import com.yogpc.qp.machines.quarry.Target;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class FrameTarget
extends Target {
    final Area area;
    private final Iterator<BlockPos> iterator;
    @Nullable
    private BlockPos currentTarget;

    FrameTarget(Area area) {
        this.area = area;
        this.iterator = Area.getFramePosStream(area).iterator();
        this.currentTarget = this.iterator.hasNext() ? this.iterator.next() : null;
    }

    FrameTarget(Area area, BlockPos pre) {
        this.area = area;
        this.iterator = Area.getFramePosStream(area).dropWhile(p -> !p.equals((Object)pre)).iterator();
        this.currentTarget = this.iterator.hasNext() ? this.iterator.next() : null;
    }

    @Override
    @Nullable
    public BlockPos get(boolean goNext) {
        BlockPos pre = this.currentTarget;
        if (goNext) {
            this.currentTarget = this.iterator.hasNext() ? this.iterator.next() : null;
        }
        return pre;
    }

    @Override
    @NotNull
    public Stream<BlockPos> allPoses() {
        return Area.getFramePosStream(this.area);
    }

    @Override
    @NotNull
    public CompoundTag toNbt() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("area", (Tag)this.area.toNBT());
        tag.m_128356_("currentTarget", Objects.requireNonNullElse(this.currentTarget, new BlockPos(this.area.minX(), this.area.maxY(), this.area.minZ() + 1)).m_121878_());
        return tag;
    }

    static FrameTarget from(CompoundTag tag) {
        return new FrameTarget(Area.fromNBT(tag.m_128469_("area")).orElseThrow(), BlockPos.m_122022_((long)tag.m_128454_("currentTarget")));
    }

    public String toString() {
        return "FrameTarget{area=" + this.area + ", currentTarget=" + this.currentTarget + ", hasNext=" + this.iterator.hasNext() + "}";
    }
}

