/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.workbench;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.yogpc.qp.machines.workbench.IngredientList;
import com.yogpc.qp.machines.workbench.IngredientRecipe;
import com.yogpc.qp.machines.workbench.WorkbenchRecipeSerializer;
import com.yogpc.qp.utils.MapMulti;
import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.crafting.CraftingHelper;

class IngredientRecipeSerialize
implements WorkbenchRecipeSerializer.PacketSerialize<IngredientRecipe> {
    IngredientRecipeSerialize() {
    }

    @Override
    public IngredientRecipe fromJson(ResourceLocation id, JsonObject jsonObject) {
        List<IngredientList> input;
        ItemStack result = CraftingHelper.getItemStack((JsonObject)jsonObject.getAsJsonObject("result"), (boolean)true);
        long energy = (long)(GsonHelper.m_144742_((JsonObject)jsonObject, (String)"energy", (double)1000.0) * 1.0E9);
        boolean showInJei = GsonHelper.m_13855_((JsonObject)jsonObject, (String)"showInJEI", (boolean)true);
        if (jsonObject.get("ingredients").isJsonObject()) {
            input = List.of(IngredientList.fromJson(jsonObject.get("ingredients")));
        } else if (jsonObject.get("ingredients").isJsonArray()) {
            input = StreamSupport.stream(jsonObject.get("ingredients").getAsJsonArray().spliterator(), false).map(IngredientList::fromJson).toList();
        } else {
            throw new IllegalArgumentException("Bad Json type of ingredients. " + jsonObject.get("ingredients"));
        }
        return new IngredientRecipe(id, result, energy, showInJei, input);
    }

    @Override
    public JsonObject toJson(JsonObject jsonObject, IngredientRecipe recipe) {
        jsonObject.add("result", (JsonElement)WorkbenchRecipeSerializer.PacketSerialize.toJson(recipe.m_8043_()));
        jsonObject.addProperty("energy", (Number)((double)recipe.getRequiredEnergy() / 1.0E9));
        jsonObject.addProperty("showInJEI", Boolean.valueOf(recipe.showInJEI()));
        jsonObject.add("ingredients", (JsonElement)recipe.inputs().stream().map(IngredientList::toJson).collect(MapMulti.jsonArrayCollector()));
        return jsonObject;
    }

    @Override
    public IngredientRecipe fromPacket(ResourceLocation id, FriendlyByteBuf buffer) {
        ItemStack output = buffer.m_130267_();
        long energy = buffer.readLong();
        boolean showInJei = buffer.readBoolean();
        int inputSize = buffer.m_130242_();
        List<IngredientList> input = IntStream.range(0, inputSize).mapToObj(i -> IngredientList.fromPacket(buffer)).toList();
        return new IngredientRecipe(id, output, energy, showInJei, input);
    }

    @Override
    public void toPacket(FriendlyByteBuf buffer, IngredientRecipe recipe) {
        buffer.writeItemStack(recipe.m_8043_(), false);
        buffer.writeLong(recipe.getRequiredEnergy()).writeBoolean(recipe.showInJEI());
        buffer.m_130130_(recipe.inputs().size());
        for (IngredientList input : recipe.inputs()) {
            input.toPacket(buffer);
        }
    }
}

