/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.workbench;

import com.google.gson.JsonObject;
import com.yogpc.qp.machines.workbench.IngredientRecipeSerialize;
import com.yogpc.qp.machines.workbench.WorkbenchRecipe;
import java.util.Map;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class WorkbenchRecipeSerializer
extends ForgeRegistryEntry<RecipeSerializer<?>>
implements RecipeSerializer<WorkbenchRecipe> {
    private final Map<String, PacketSerialize<? extends WorkbenchRecipe>> serializeMap;

    WorkbenchRecipeSerializer() {
        this.setRegistryName(WorkbenchRecipe.recipeLocation);
        this.serializeMap = Map.of("default", new IngredientRecipeSerialize());
    }

    public WorkbenchRecipe fromJson(ResourceLocation id, JsonObject jsonObject) {
        String subType = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"subType", (String)"default");
        return this.serializeMap.get(subType).fromJson(id, jsonObject);
    }

    public JsonObject toJson(WorkbenchRecipe recipe, JsonObject o) {
        o.addProperty("subType", recipe.getSubTypeName());
        return WorkbenchRecipeSerializer.toJson(o, this.serializeMap.get(recipe.getSubTypeName()), recipe);
    }

    private static <T extends WorkbenchRecipe> JsonObject toJson(JsonObject object, PacketSerialize<T> serialize, WorkbenchRecipe recipe) {
        return serialize.toJson(object, recipe);
    }

    public WorkbenchRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
        String subType = buffer.m_130277_();
        return this.serializeMap.get(subType).fromPacket(id, buffer);
    }

    public void toNetwork(FriendlyByteBuf buffer, WorkbenchRecipe recipe) {
        buffer.m_130070_(recipe.getSubTypeName());
        WorkbenchRecipeSerializer.toNetwork(this.serializeMap.get(recipe.getSubTypeName()), buffer, recipe);
    }

    private static <T extends WorkbenchRecipe> void toNetwork(PacketSerialize<T> serialize, FriendlyByteBuf buffer, WorkbenchRecipe recipe) {
        serialize.toPacket(buffer, recipe);
    }

    static interface PacketSerialize<T extends WorkbenchRecipe> {
        public T fromJson(ResourceLocation var1, JsonObject var2);

        public JsonObject toJson(JsonObject var1, T var2);

        public T fromPacket(ResourceLocation var1, FriendlyByteBuf var2);

        public void toPacket(FriendlyByteBuf var1, T var2);

        public static JsonObject toJson(ItemStack stack) {
            JsonObject o = new JsonObject();
            o.addProperty("item", Objects.requireNonNull(stack.m_41720_().getRegistryName()).toString());
            o.addProperty("count", (Number)stack.m_41613_());
            if (stack.m_41783_() != null) {
                o.addProperty("nbt", stack.m_41783_().toString());
            }
            return o;
        }
    }
}

