/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.registry.hooks;

import com.mojang.serialization.DynamicOps;
import com.terraforged.mod.Environment;
import com.terraforged.mod.TerraForged;
import com.terraforged.mod.util.ReflectionUtil;
import java.lang.invoke.MethodHandle;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.RegistryReadOps;
import net.minecraft.resources.ResourceKey;

public class RegistryAccessUtil {
    private static final MethodHandle REGISTRY_ACCESS_GETTER = ReflectionUtil.field(RegistryReadOps.class, RegistryAccess.class, new String[0]);
    private static final MethodHandle REGISTRY_HOLDER_MAP = ReflectionUtil.field(RegistryAccess.RegistryHolder.class, Map.class, new String[0]);

    public static Optional<RegistryAccess> getRegistryAccess(DynamicOps<?> ops) {
        if (!(ops instanceof RegistryReadOps)) {
            return Optional.empty();
        }
        try {
            return Optional.ofNullable(RegistryAccessUtil.getRegistryAccess((RegistryReadOps)ops));
        }
        catch (Throwable t) {
            t.printStackTrace();
            return Optional.empty();
        }
    }

    public static RegistryAccess getRegistryAccess(RegistryReadOps<?> ops) {
        try {
            return REGISTRY_ACCESS_GETTER.invokeExact(ops);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> void copy(Registry<T> registry, RegistryAccess.RegistryHolder holder) {
        WritableRegistry dest = holder.m_175512_(registry.m_123023_());
        for (Map.Entry entry : registry.m_6579_()) {
            dest.m_7135_((ResourceKey)entry.getKey(), entry.getValue(), registry.m_6228_(entry.getValue()));
        }
    }

    public static void printRegistryContents(Registry<?> registry) {
        if (!Environment.DEBUGGING) {
            return;
        }
        TerraForged.LOG.info(" - Registry: {}, Size: {}", (Object)registry.m_123023_().m_135782_(), (Object)registry.m_183450_());
        for (Map.Entry entry : registry.m_6579_()) {
            TerraForged.LOG.info("  - {}", (Object)((ResourceKey)entry.getKey()).m_135782_());
        }
    }
}

