/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.util;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.terraforged.mod.Environment;
import com.terraforged.mod.worldgen.Generator;
import com.terraforged.mod.worldgen.profiler.GeneratorProfiler;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkSource;

public class DemoHandler {
    private static final String WARNING = "This version of TerraForged has been provided for demo purposes only and may not be suitable for survival play. Please do NOT report bugs, compatibility issues, or feedback regarding this version of the mod.";

    public static void renderOverlay(PoseStack stack) {
        if (Environment.DEV_ENV) {
            return;
        }
        Minecraft client = Minecraft.m_91087_();
        if (!client.m_91302_()) {
            return;
        }
        LocalPlayer player = client.f_91074_;
        if (player == null) {
            return;
        }
        if (!DemoHandler.isTFWorld(player.f_19853_)) {
            return;
        }
        Window window = client.m_91268_();
        Font font = client.f_91062_;
        int width = window.m_85445_();
        int height = window.m_85446_();
        String text = "TerraForged Demo";
        int x = width - font.m_92895_(text) - 5;
        Objects.requireNonNull(font);
        int y = height - 9 - 5;
        font.m_92750_(stack, text, (float)x, (float)y, -65536);
    }

    public static void warn(Player player) {
        ServerChunkCache serverSource;
        if (player == null || Environment.DEV_ENV) {
            return;
        }
        ChunkSource chunkSource = player.f_19853_.m_7726_();
        if (chunkSource instanceof ServerChunkCache && DemoHandler.isTFGenerator((serverSource = (ServerChunkCache)chunkSource).m_8481_())) {
            player.m_6352_((Component)new TextComponent(WARNING).m_130940_(ChatFormatting.RED), Util.f_137441_);
        }
    }

    private static boolean isTFWorld(Level level) {
        return level.m_6042_().m_63969_().m_135827_().equals("terraforged");
    }

    private static boolean isTFGenerator(ChunkGenerator generator) {
        return generator instanceof GeneratorProfiler || generator instanceof Generator;
    }
}

