/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.util.seed;

import com.mojang.serialization.Lifecycle;
import com.terraforged.mod.Environment;
import com.terraforged.mod.TerraForged;
import com.terraforged.mod.worldgen.Generator;
import com.terraforged.mod.worldgen.profiler.GeneratorProfiler;
import java.util.OptionalInt;
import net.minecraft.core.MappedRegistry;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;

public class SeedUtil {
    public static MappedRegistry<LevelStem> reseed(long seed, MappedRegistry<LevelStem> registry) {
        LevelStem overworld = (LevelStem)registry.m_123013_(LevelStem.f_63971_);
        ChunkGenerator generator = overworld.m_63990_();
        if (generator instanceof Generator) {
            generator = generator.m_6819_(seed);
            TerraForged.LOG.info("Re-seeded TerraForged generator: {}", (Object)seed);
        }
        if (Environment.PROFILING) {
            generator = SeedUtil.withProfiler(generator);
        }
        if (generator == overworld.m_63990_()) {
            return registry;
        }
        Lifecycle lifecycle = registry.m_6228_((Object)overworld);
        LevelStem levelStem = new LevelStem(overworld.m_63981_(), generator);
        registry.m_7794_(OptionalInt.empty(), LevelStem.f_63971_, (Object)levelStem, lifecycle);
        if (GeneratorProfiler.PROFILING.get()) {
            TerraForged.LOG.info("Attached generator profiler");
        }
        return registry;
    }

    public static ChunkGenerator withProfiler(ChunkGenerator generator) {
        if (GeneratorProfiler.PROFILING.get()) {
            return GeneratorProfiler.wrap(generator);
        }
        return generator;
    }
}

