/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen;

import com.terraforged.mod.worldgen.Generator;
import com.terraforged.mod.worldgen.util.StructureConfig;
import com.terraforged.mod.worldgen.util.delegate.DelegateGenerator;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseSampler;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class VanillaGen {
    protected final StructureConfig structureConfig;
    protected final NoiseSampler noiseSampler;
    protected final NoiseBasedChunkGenerator vanillaGenerator;
    protected final Supplier<NoiseGeneratorSettings> settings;
    protected final Registry<NormalNoise.NoiseParameters> parameters;
    protected final int lavaLevel;
    protected final Aquifer.FluidStatus fluidStatus1;
    protected final Aquifer.FluidStatus fluidStatus2;
    protected final Aquifer.FluidPicker globalFluidPicker;

    public VanillaGen(long seed, BiomeSource biomeSource, VanillaGen other) {
        this(seed, biomeSource, other.settings, other.parameters);
    }

    public VanillaGen(long seed, BiomeSource biomeSource, Supplier<NoiseGeneratorSettings> settings, Registry<NormalNoise.NoiseParameters> parameters) {
        this.settings = settings;
        this.parameters = parameters;
        this.structureConfig = new StructureConfig(settings.get().m_64457_());
        this.vanillaGenerator = new NoiseBasedChunkGenerator(parameters, biomeSource, seed, settings);
        this.noiseSampler = new NoiseSampler(settings.get().m_64481_(), settings.get().m_158568_(), seed, parameters, settings.get().m_188893_());
        this.lavaLevel = Math.min(-54, settings.get().m_64486_());
        this.fluidStatus1 = new Aquifer.FluidStatus(-54, Blocks.f_49991_.m_49966_());
        this.fluidStatus2 = new Aquifer.FluidStatus(settings.get().m_64486_(), settings.get().m_64483_());
        this.globalFluidPicker = (x, y, z) -> y < this.lavaLevel ? this.fluidStatus1 : this.fluidStatus2;
    }

    public Supplier<NoiseGeneratorSettings> getSettings() {
        return this.settings;
    }

    public StructureSettings getStructureSettings() {
        return new StructureConfig(this.getSettings().get().m_64457_()).copy();
    }

    public Aquifer.FluidPicker getGlobalFluidPicker() {
        return this.globalFluidPicker;
    }

    public NoiseSampler getNoiseSampler() {
        return this.noiseSampler;
    }

    public ChunkGenerator getVanillaGenerator() {
        return this.vanillaGenerator;
    }

    public ChunkGenerator createStructureGenerator(long seed, Generator generator) {
        return new DelegateGenerator(seed, generator, this.settings){};
    }

    public CarvingContext createCarvingContext(WorldGenRegion region, ChunkAccess chunk, NoiseChunk noiseChunk) {
        return new CarvingContext(this.vanillaGenerator, region.m_5962_(), chunk.m_183618_(), noiseChunk);
    }
}

