/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen.asset;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.terraforged.engine.world.terrain.ITerrain;
import com.terraforged.engine.world.terrain.Terrain;
import com.terraforged.engine.world.terrain.TerrainHelper;
import com.terraforged.mod.codec.LazyCodec;
import com.terraforged.mod.registry.ModRegistry;
import java.util.function.Supplier;

public class TerrainType {
    public static final TerrainType NONE = new TerrainType("none", com.terraforged.engine.world.terrain.TerrainType.NONE);
    public static final Codec<TerrainType> DIRECT = LazyCodec.record(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(TerrainType::getName), (App)Codec.STRING.fieldOf("parent").xmap(TerrainType::forName, Terrain::getName).forGetter(TerrainType::getParentType)).apply((Applicative)instance, TerrainType::new));
    public static final Codec<Supplier<TerrainType>> CODEC = LazyCodec.registry(DIRECT, ModRegistry.TERRAIN_TYPE);
    private final String name;
    private final Terrain parentType;
    private final Terrain terrain;

    public TerrainType(String name, Terrain type) {
        this.name = name;
        this.parentType = type;
        this.terrain = TerrainHelper.getOrCreate(name, type);
    }

    public String getName() {
        return this.name;
    }

    public Terrain getTerrain() {
        return this.terrain;
    }

    public Terrain getParentType() {
        return this.parentType;
    }

    private static Terrain forName(String name) {
        return com.terraforged.engine.world.terrain.TerrainType.get(name);
    }

    public static TerrainType of(Terrain terrain) {
        ITerrain iTerrain = terrain.getDelegate();
        if (iTerrain instanceof Terrain) {
            Terrain parent = (Terrain)iTerrain;
            return new TerrainType(terrain.getName(), parent);
        }
        return new TerrainType(terrain.getName(), terrain);
    }
}

