/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen.biome;

import com.terraforged.mod.data.ModBiomes;
import com.terraforged.mod.util.map.WeightMap;
import com.terraforged.mod.worldgen.biome.util.BiomeMapManager;
import com.terraforged.mod.worldgen.cave.CaveType;
import com.terraforged.noise.util.Noise;
import com.terraforged.noise.util.NoiseUtil;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.world.level.biome.Biome;

public class CaveBiomeSampler {
    public static final int OFFSET = 124897;
    protected final int seed;
    protected final int scale;
    protected final float frequency;
    protected final Map<CaveType, WeightMap<Biome>> typeMap = new EnumMap<CaveType, WeightMap<Biome>>(CaveType.class);

    public CaveBiomeSampler(long seed, int scale, BiomeMapManager biomeMapManager) {
        this.seed = (int)seed + 124897;
        this.scale = scale;
        this.frequency = 1.0f / (float)scale;
        Biome[] global = new Biome[]{(Biome)biomeMapManager.getBiomes().m_123013_(ModBiomes.CAVE.key())};
        Biome[] special = (Biome[])biomeMapManager.getBiomes().m_123024_().filter(b -> b.m_47567_() == Biome.BiomeCategory.UNDERGROUND).toArray(Biome[]::new);
        this.typeMap.put(CaveType.GLOBAL, CaveBiomeSampler.create(global));
        this.typeMap.put(CaveType.UNIQUE, CaveBiomeSampler.create(special));
    }

    public CaveBiomeSampler(long seed, CaveBiomeSampler other) {
        this.seed = (int)seed + 124897;
        this.scale = other.scale;
        this.frequency = 1.0f / (float)other.scale;
        this.typeMap.putAll(other.typeMap);
    }

    public Biome getUnderGroundBiome(int seed, int x, int z, CaveType type) {
        float noise = CaveBiomeSampler.sample(seed + this.seed, x, z, this.frequency);
        return this.typeMap.get((Object)type).getValue(noise);
    }

    protected static float sample(int seed, int x, int z, float frequency) {
        float nx = (float)x * frequency;
        float nz = (float)z * frequency;
        float noise = (1.0f + Noise.singleSimplex(nx, nz, seed)) * 0.5f;
        return NoiseUtil.clamp(noise, 0.0f, 1.0f);
    }

    protected static WeightMap<Biome> create(Biome[] biomes) {
        float[] weights = new float[biomes.length];
        Arrays.fill(weights, 1.0f);
        return new WeightMap<Biome>(biomes, weights);
    }
}

