/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen.biome;

import com.terraforged.engine.cell.Cell;
import com.terraforged.engine.world.climate.ClimateModule;
import com.terraforged.engine.world.terrain.TerrainType;
import com.terraforged.mod.worldgen.noise.INoiseGenerator;
import com.terraforged.mod.worldgen.noise.NoiseLevels;
import com.terraforged.mod.worldgen.noise.NoiseSample;
import com.terraforged.mod.worldgen.noise.RiverCache;

public interface IBiomeSampler {
    public ClimateModule getClimate();

    public ClimateSample sample(int var1, int var2);

    public float getShape(int var1, int var2);

    public static ClimateModule createClimate(INoiseGenerator generator) {
        if (generator == null) {
            return null;
        }
        return new ClimateModule(generator.getContinent(), generator.getContinent().getContext());
    }

    public static class ClimateSample
    extends NoiseSample {
        public final Cell cell = new Cell();
        public final RiverCache riverCache = new RiverCache();

        public ClimateSample reset() {
            this.cell.reset();
            this.heightNoise = 1.0f;
            this.terrainType = TerrainType.FLATS;
            return this;
        }
    }

    public static class Sampler
    implements IBiomeSampler {
        protected final NoiseLevels levels;
        protected final ClimateModule climateModule;
        protected final INoiseGenerator noiseGenerator;
        protected final ThreadLocal<ClimateSample> localSample = ThreadLocal.withInitial(ClimateSample::new);

        public Sampler(INoiseGenerator noiseGenerator) {
            this.levels = noiseGenerator.getLevels();
            this.climateModule = IBiomeSampler.createClimate(noiseGenerator);
            this.noiseGenerator = noiseGenerator;
        }

        public INoiseGenerator getNoiseGenerator() {
            return this.noiseGenerator;
        }

        @Override
        public ClimateModule getClimate() {
            return this.climateModule;
        }

        @Override
        public ClimateSample sample(int x, int z) {
            float px = (float)x * this.levels.frequency;
            float pz = (float)z * this.levels.frequency;
            ClimateSample sample = this.localSample.get().reset();
            this.noiseGenerator.getContinent().sampleContinent(px, pz, sample);
            this.noiseGenerator.getContinent().sampleRiver(px, pz, sample, sample.riverCache);
            Cell cell = sample.cell;
            cell.value = sample.heightNoise;
            cell.terrain = sample.terrainType;
            cell.riverMask = sample.riverNoise;
            cell.continentEdge = sample.continentNoise;
            this.climateModule.apply(cell, px, pz);
            return sample;
        }

        @Override
        public float getShape(int x, int z) {
            float px = (float)x * this.levels.frequency;
            float pz = (float)z * this.levels.frequency;
            ClimateSample sample = this.localSample.get().reset();
            Cell cell = sample.cell;
            this.climateModule.apply(cell, px, pz);
            return sample.cell.biomeRegionEdge;
        }
    }
}

