/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen.biome;

import com.mojang.serialization.Codec;
import com.terraforged.engine.util.pos.PosUtil;
import com.terraforged.mod.util.map.LossyCache;
import com.terraforged.mod.worldgen.biome.BiomeSampler;
import com.terraforged.mod.worldgen.biome.CaveBiomeSampler;
import com.terraforged.mod.worldgen.biome.SourceCodec;
import com.terraforged.mod.worldgen.biome.util.BiomeMapManager;
import com.terraforged.mod.worldgen.cave.CaveType;
import com.terraforged.mod.worldgen.noise.INoiseGenerator;
import it.unimi.dsi.fastutil.longs.Long2ObjectFunction;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;

public class Source
extends BiomeSource {
    public static final Codec<Source> CODEC = new SourceCodec();
    protected final long seed;
    protected final RegistryAccess registries;
    protected final Set<Biome> f_47891_;
    protected final BiomeSampler biomeSampler;
    protected final BiomeMapManager biomeMapManager;
    protected final CaveBiomeSampler caveBiomeSampler;
    protected final LossyCache<Biome> cache = LossyCache.concurrent(2048, Biome[]::new);

    public Source(long seed, INoiseGenerator noise, Source other) {
        super(List.of());
        this.seed = seed;
        this.registries = other.registries;
        this.biomeMapManager = other.biomeMapManager;
        this.f_47891_ = new ObjectLinkedOpenHashSet(other.f_47891_);
        this.biomeSampler = new BiomeSampler(noise, other.biomeMapManager);
        this.caveBiomeSampler = new CaveBiomeSampler(seed, other.caveBiomeSampler);
    }

    public Source(long seed, INoiseGenerator noise, RegistryAccess access) {
        super(List.of());
        this.seed = seed;
        this.registries = access;
        this.biomeMapManager = new BiomeMapManager(access);
        this.f_47891_ = new ObjectLinkedOpenHashSet(this.biomeMapManager.getOverworldBiomes());
        this.biomeSampler = new BiomeSampler(noise, this.biomeMapManager);
        this.caveBiomeSampler = new CaveBiomeSampler(seed, 800, this.biomeMapManager);
    }

    public Set<Biome> m_196676_() {
        return this.f_47891_;
    }

    protected Codec<? extends BiomeSource> m_5820_() {
        return CODEC;
    }

    public Source withSeed(long l) {
        return this;
    }

    public Biome m_183546_(int x, int y, int z, Climate.Sampler sampler) {
        return this.cache.computeIfAbsent(PosUtil.pack(x, z), (Long2ObjectFunction<Biome>)((Long2ObjectFunction)this::compute));
    }

    public RegistryAccess getRegistries() {
        return this.registries;
    }

    public BiomeSampler getBiomeSampler() {
        return this.biomeSampler;
    }

    public CaveBiomeSampler getCaveBiomeSampler() {
        return this.caveBiomeSampler;
    }

    public Biome getUnderGroundBiome(int seed, int x, int z, CaveType type) {
        return this.caveBiomeSampler.getUnderGroundBiome(seed, x, z, type);
    }

    public Registry<Biome> getRegistry() {
        return this.biomeMapManager.getBiomes();
    }

    protected Biome compute(long index) {
        int x = PosUtil.unpackLeft(index) << 2;
        int z = PosUtil.unpackRight(index) << 2;
        return this.biomeSampler.sampleBiome(x, z);
    }

    public static class NoopSampler
    implements Climate.Sampler {
        public static final NoopSampler INSTANCE = new NoopSampler();
        public static final Climate.TargetPoint DEFAULT_POINT = new Climate.TargetPoint(0L, 0L, 0L, 0L, 0L, 0L);

        public Climate.TargetPoint m_183445_(int i, int i1, int i2) {
            return DEFAULT_POINT;
        }
    }
}

