/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen.biome.util;

import com.terraforged.engine.world.biome.type.BiomeType;
import com.terraforged.mod.TerraForged;
import com.terraforged.mod.registry.ModRegistry;
import com.terraforged.mod.util.map.WeightMap;
import com.terraforged.mod.worldgen.asset.ClimateType;
import com.terraforged.mod.worldgen.biome.util.BiomeUtil;
import it.unimi.dsi.fastutil.objects.Object2FloatLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;

public class BiomeMapManager {
    private static final BiomeType[] TYPES = BiomeType.values();
    private static final BiomeTypeHolder[] HOLDERS = (BiomeTypeHolder[])Stream.of(TYPES).map(BiomeTypeHolder::new).toArray(BiomeTypeHolder[]::new);
    private final Registry<Biome> biomes;
    private final Registry<ClimateType> climateTypes;
    private final List<Biome> overworldBiomes;
    private final Map<BiomeType, WeightMap<Biome>> biomeMap;

    public BiomeMapManager(RegistryAccess access) {
        this.biomes = access.m_175512_(Registry.f_122885_);
        this.climateTypes = access.m_175512_(ModRegistry.CLIMATE.get());
        this.overworldBiomes = BiomeMapManager.getOverworldBiomes(this.biomes, this.climateTypes);
        this.biomeMap = this.buildBiomeMap();
    }

    public Biome get(ResourceKey<Biome> key) {
        return (Biome)this.biomes.m_6246_(key);
    }

    public Registry<Biome> getBiomes() {
        return this.biomes;
    }

    public List<Biome> getOverworldBiomes() {
        return this.overworldBiomes;
    }

    public Map<BiomeType, WeightMap<Biome>> getBiomeMap() {
        return this.biomeMap;
    }

    private Map<BiomeType, WeightMap<Biome>> buildBiomeMap() {
        Map<BiomeType, Object2FloatMap<Biome>> map = this.getWeightsMap();
        EnumMap<BiomeType, WeightMap<Biome>> result = new EnumMap<BiomeType, WeightMap<Biome>>(BiomeType.class);
        for (Map.Entry<BiomeType, Object2FloatMap<Biome>> entry : map.entrySet()) {
            Biome[] values = (Biome[])entry.getValue().keySet().toArray(Biome[]::new);
            float[] weights = entry.getValue().values().toFloatArray();
            result.put(entry.getKey(), new WeightMap<Biome>(values, weights));
        }
        return result;
    }

    private Map<BiomeType, Object2FloatMap<Biome>> getWeightsMap() {
        HashMap<BiomeType, Object2FloatMap<Biome>> map = new HashMap<BiomeType, Object2FloatMap<Biome>>();
        ObjectOpenHashSet registered = new ObjectOpenHashSet();
        for (BiomeTypeHolder typeHolder : HOLDERS) {
            ClimateType biomeType = (ClimateType)this.climateTypes.m_7745_(typeHolder.name);
            if (biomeType == null) {
                map.put(typeHolder.type(), BiomeMapManager.newMutableWeightMap());
                continue;
            }
            Object2FloatMap<Biome> typeMap = BiomeMapManager.getBiomeWeights(biomeType, this.biomes, arg_0 -> ((ObjectOpenHashSet)registered).add(arg_0));
            map.put(typeHolder.type(), typeMap);
        }
        for (Biome biome : this.overworldBiomes) {
            BiomeType type;
            if (registered.contains((Object)biome) || (type = BiomeUtil.getType(biome)) == null) continue;
            map.computeIfAbsent(type, t -> new Object2FloatLinkedOpenHashMap()).put((Object)biome, 1.0f);
        }
        return map;
    }

    private static Object2FloatMap<Biome> getBiomeWeights(ClimateType type, Registry<Biome> biomes, Consumer<Biome> registered) {
        Object2FloatMap<Biome> map = BiomeMapManager.newMutableWeightMap();
        for (Object2FloatMap.Entry entry : type.getWeights().object2FloatEntrySet()) {
            Biome biome = (Biome)biomes.m_7745_((ResourceLocation)entry.getKey());
            if (biome == null) continue;
            map.put((Object)biome, entry.getFloatValue());
            registered.accept(biome);
        }
        return map;
    }

    private static List<Biome> getOverworldBiomes(Registry<Biome> biomes, Registry<ClimateType> biomeTypes) {
        List<Biome> list = BiomeUtil.getOverworldBiomes(biomes);
        ObjectOpenHashSet added = new ObjectOpenHashSet(list);
        for (ClimateType type : biomeTypes) {
            for (ResourceLocation key : type.getWeights().keySet()) {
                Biome biome = (Biome)biomes.m_7745_(key);
                if (biome == null || !added.add((Object)biome)) continue;
                list.add(biome);
            }
        }
        list.sort(BiomeUtil.getBiomeSorter(biomes));
        return list;
    }

    private static Object2FloatMap<Biome> newMutableWeightMap() {
        return new Object2FloatLinkedOpenHashMap();
    }

    private record BiomeTypeHolder(BiomeType type, ResourceLocation name) {
        public BiomeTypeHolder(BiomeType type) {
            this(type, TerraForged.location(type.name().toLowerCase(Locale.ROOT)));
        }
    }
}

