/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen.biome.vegetation;

import com.terraforged.mod.data.ModVegetations;
import com.terraforged.mod.worldgen.asset.VegetationConfig;
import com.terraforged.mod.worldgen.biome.vegetation.BiomeVegetation;
import com.terraforged.mod.worldgen.biome.vegetation.VegetationFeatures;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;

public class BiomeVegetationManager {
    private final Map<Biome, BiomeVegetation> vegetation = new IdentityHashMap<Biome, BiomeVegetation>();

    public BiomeVegetationManager(RegistryAccess access) {
        Registry biomes = access.m_175515_(Registry.f_122885_);
        VegetationConfig[] configs = ModVegetations.getVegetation(access);
        for (Map.Entry entry : biomes.m_6579_()) {
            Biome biome = (Biome)entry.getValue();
            VegetationConfig config = BiomeVegetationManager.getConfig(biome, configs);
            VegetationFeatures features = VegetationFeatures.create((ResourceKey<Biome>)((ResourceKey)entry.getKey()), access, config);
            this.vegetation.put(biome, new BiomeVegetation(config, features));
        }
    }

    public BiomeVegetation getVegetation(Biome biome) {
        return this.vegetation.get(biome);
    }

    private static VegetationConfig getViability(Biome biome, Registry<VegetationConfig> registry) {
        return registry.m_123024_().filter(vc -> vc.biomes().get().contains(biome)).findFirst().orElse(VegetationConfig.NONE);
    }

    private static VegetationConfig[] getConfigs(RegistryAccess access) {
        return ModVegetations.getVegetation(access);
    }

    private static VegetationConfig getConfig(Biome biome, VegetationConfig[] configs) {
        for (VegetationConfig config : configs) {
            if (!config.biomes().get().contains(biome)) continue;
            return config;
        }
        return VegetationConfig.NONE;
    }
}

