/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen.biome.vegetation;

import com.google.common.collect.ImmutableSet;
import com.terraforged.mod.util.ReflectionUtil;
import com.terraforged.mod.worldgen.asset.VegetationConfig;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class VegetationFeatures {
    public static VegetationFeatures NONE = new VegetationFeatures();
    public static final int STAGE = GenerationStep.Decoration.VEGETAL_DECORATION.ordinal();
    private static final MethodHandle FEATURE_GETTER = ReflectionUtil.field(PlacedFeature.class, Supplier.class, new String[0]);
    private static final MethodHandle PLACEMENTS_GETTER = ReflectionUtil.field(PlacedFeature.class, List.class, new String[0]);
    private static final Set<PlacementModifierType<?>> BIOME_CHECK = Set.of(PlacementModifierType.f_191852_);
    private static final Set<PlacementModifierType<?>> EXCLUSIONS = Set.of(PlacementModifierType.f_191852_, PlacementModifierType.f_191853_, PlacementModifierType.f_191856_, PlacementModifierType.f_191854_, PlacementModifierType.f_191855_);
    private static final Set<PlacementModifierType<?>> TREE_EXCLUSIONS = ImmutableSet.builder().addAll(EXCLUSIONS).add((Object)PlacementModifierType.f_191860_).build();
    protected static final String[] TREE_KEYWORDS = new String[]{"tree", "spruce", "oak", "birch", "pine", "dark_forest_vegetation"};
    protected static final String[] GRASS_KEYWORDS = new String[]{"grass"};
    private final PlacedFeature[] trees;
    private final PlacedFeature[] grass;
    private final PlacedFeature[] other;

    private VegetationFeatures() {
        this.trees = new PlacedFeature[0];
        this.grass = new PlacedFeature[0];
        this.other = new PlacedFeature[0];
    }

    public VegetationFeatures(List<PlacedFeature> trees, List<PlacedFeature> grass, List<PlacedFeature> other) {
        this.trees = (PlacedFeature[])trees.toArray(PlacedFeature[]::new);
        this.grass = (PlacedFeature[])grass.toArray(PlacedFeature[]::new);
        this.other = (PlacedFeature[])other.toArray(PlacedFeature[]::new);
    }

    public PlacedFeature[] trees() {
        return this.trees;
    }

    public PlacedFeature[] grass() {
        return this.grass;
    }

    public PlacedFeature[] other() {
        return this.other;
    }

    public static VegetationFeatures create(ResourceKey<Biome> key, RegistryAccess access, VegetationConfig config) {
        ArrayList<PlacedFeature> trees = new ArrayList<PlacedFeature>();
        ArrayList<PlacedFeature> grass = new ArrayList<PlacedFeature>();
        ArrayList<PlacedFeature> other = new ArrayList<PlacedFeature>();
        boolean custom = config != VegetationConfig.NONE;
        Registry biomeRegistry = access.m_175515_(Registry.f_122885_);
        List features = ((Biome)biomeRegistry.m_123013_(key)).m_47536_().m_47818_();
        if (features.size() > STAGE) {
            List vegetation = (List)features.get(STAGE);
            Registry featureRegistry = access.m_175515_(Registry.f_194567_);
            for (Supplier feature : vegetation) {
                ResourceLocation featureKey = featureRegistry.m_7981_((Object)((PlacedFeature)feature.get()));
                if (featureKey == null) {
                    other.add((PlacedFeature)feature.get());
                    continue;
                }
                String path = featureKey.m_135815_();
                if (VegetationFeatures.matches(path, TREE_KEYWORDS)) {
                    trees.add(VegetationFeatures.unwrap(feature, TREE_EXCLUSIONS, custom));
                    continue;
                }
                if (VegetationFeatures.matches(path, GRASS_KEYWORDS)) {
                    grass.add((PlacedFeature)feature.get());
                    continue;
                }
                other.add((PlacedFeature)feature.get());
            }
        }
        return new VegetationFeatures(trees, grass, other);
    }

    protected static boolean matches(String name, String[] keywords) {
        for (String keyword : keywords) {
            if (!name.contains(keyword)) continue;
            return true;
        }
        return false;
    }

    public static PlacedFeature unwrap(Supplier<PlacedFeature> supplier, Set<PlacementModifierType<?>> exclusions, boolean custom) {
        if (!custom) {
            return supplier.get();
        }
        try {
            PlacedFeature placed = supplier.get();
            Supplier<ConfiguredFeature<?, ?>> feature = VegetationFeatures.getFeature(placed);
            ArrayList<PlacementModifier> placements = new ArrayList<PlacementModifier>(VegetationFeatures.getPlacements(placed));
            placements.removeIf(placement -> exclusions.contains(placement.m_183327_()));
            return new PlacedFeature(feature, placements);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return supplier.get();
        }
    }

    protected static Supplier<ConfiguredFeature<?, ?>> getFeature(PlacedFeature feature) throws Throwable {
        return FEATURE_GETTER.invokeExact(feature);
    }

    protected static List<PlacementModifier> getPlacements(PlacedFeature feature) throws Throwable {
        return PLACEMENTS_GETTER.invokeExact(feature);
    }
}

