/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen.cave;

import com.terraforged.mod.registry.ModRegistry;
import com.terraforged.mod.util.ObjectPool;
import com.terraforged.mod.worldgen.Generator;
import com.terraforged.mod.worldgen.asset.NoiseCave;
import com.terraforged.mod.worldgen.cave.CarverChunk;
import com.terraforged.mod.worldgen.cave.CaveType;
import com.terraforged.mod.worldgen.cave.NoiseCaveCarver;
import com.terraforged.mod.worldgen.cave.NoiseCaveDecorator;
import com.terraforged.mod.worldgen.cave.UniqueCaveDistributor;
import com.terraforged.noise.Module;
import com.terraforged.noise.Source;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkAccess;

public class NoiseCaveGenerator {
    protected static final int POOL_SIZE = 32;
    protected static final float DENSITY = 0.05f;
    protected static final float BREACH_THRESHOLD = 0.7f;
    protected final NoiseCave[] caves;
    protected final Module uniqueCaveNoise;
    protected final Module caveBreachNoise;
    protected final ObjectPool<CarverChunk> pool;
    protected final Map<ChunkPos, CarverChunk> cache = new ConcurrentHashMap<ChunkPos, CarverChunk>();

    public NoiseCaveGenerator(long seed, RegistryAccess access) {
        Registry global = access.m_175515_(ModRegistry.CAVE.get());
        this.uniqueCaveNoise = NoiseCaveGenerator.createUniqueNoise((int)seed, 500, 0.05f);
        this.caveBreachNoise = NoiseCaveGenerator.createBreachNoise((int)seed + 12, 300, 0.7f);
        this.caves = (NoiseCave[])global.m_123024_().map(config -> config.withSeed(seed)).toArray(NoiseCave[]::new);
        this.pool = new ObjectPool<CarverChunk>(32, this::createCarverChunk);
    }

    public NoiseCaveGenerator(long seed, NoiseCaveGenerator other) {
        this.caves = new NoiseCave[other.caves.length];
        this.uniqueCaveNoise = NoiseCaveGenerator.createUniqueNoise((int)seed, 500, 0.05f);
        this.caveBreachNoise = NoiseCaveGenerator.createBreachNoise((int)seed + 12, 300, 0.7f);
        this.pool = new ObjectPool<CarverChunk>(32, this::createCarverChunk);
        for (int i = 0; i < this.caves.length; ++i) {
            this.caves[i] = other.caves[i].withSeed(seed);
        }
    }

    public void carve(ChunkAccess chunk, Generator generator) {
        CarverChunk carver = this.getPreCarveChunk(chunk);
        for (NoiseCave config : this.caves) {
            NoiseCaveCarver.carve(chunk, carver, generator, config, this.getModifier(config), this.caveBreachNoise, true);
        }
    }

    public void decorate(ChunkAccess chunk, WorldGenLevel region, Generator generator) {
        CarverChunk carver = this.getPostCarveChunk(chunk, generator);
        for (NoiseCave config : this.caves) {
            NoiseCaveDecorator.decorate(chunk, carver, region, generator, config);
        }
        this.pool.restore(carver);
    }

    private CarverChunk getPreCarveChunk(ChunkAccess chunk) {
        return this.cache.computeIfAbsent(chunk.m_7697_(), p -> this.pool.take().reset());
    }

    private CarverChunk getPostCarveChunk(ChunkAccess chunk, Generator generator) {
        CarverChunk carver = this.cache.remove(chunk.m_7697_());
        if (carver != null) {
            return carver;
        }
        carver = this.pool.take().reset();
        for (NoiseCave config : this.caves) {
            NoiseCaveCarver.carve(chunk, carver, generator, config, this.getModifier(config), this.caveBreachNoise, false);
        }
        return carver;
    }

    private Module getModifier(NoiseCave cave) {
        return switch (cave.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case CaveType.GLOBAL -> Source.ONE;
            case CaveType.UNIQUE -> this.uniqueCaveNoise;
        };
    }

    private CarverChunk createCarverChunk() {
        return new CarverChunk(this.caves.length);
    }

    private static Module createUniqueNoise(int seed, int scale, float density) {
        return new UniqueCaveDistributor(seed + 1286745, 1.0f / (float)scale, 0.75f, density).clamp(0.2, 1.0).map(0.0, 1.0).warp(seed + 781624, 30, 1, 20.0);
    }

    private static Module createBreachNoise(int seed, int scale, float threshold) {
        return Source.simplexRidge(seed, scale, 2).clamp(threshold * 0.8f, threshold).map(0.0, 1.0);
    }
}

